/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.mcp.entity.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.seata.mcp.core.config.TimestampToStringDeserializer;
import org.apache.seata.server.console.entity.vo.GlobalSessionVO;

import java.util.Set;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.ANY;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;

@JsonAutoDetect(getterVisibility = NONE, fieldVisibility = ANY)
public class McpGlobalSessionVO extends GlobalSessionVO {

    private String beginTime;
    private String createTime;
    private String modifiedTime;
    private Set<McpBranchSessionVO> mcpBranchSessionVOS;

    @JsonProperty("beginTime")
    @JsonDeserialize(using = TimestampToStringDeserializer.class)
    public String getBegin() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    @JsonProperty("gmtCreate")
    @JsonDeserialize(using = TimestampToStringDeserializer.class)
    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JsonProperty("gmtModified")
    @JsonDeserialize(using = TimestampToStringDeserializer.class)
    public String getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    @JsonProperty("branchSessionVOs")
    public Set<McpBranchSessionVO> getMcpBranchSessionVOS() {
        return mcpBranchSessionVOS;
    }

    public void setMcpBranchSessionVOS(Set<McpBranchSessionVO> mcpBranchSessionVOS) {
        this.mcpBranchSessionVOS = mcpBranchSessionVOS;
    }
}
