/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range.hinter;

import com.google.protobuf.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinterFactory;
import org.apache.bifromq.basekv.store.range.hinter.SplitHinterContext;
import org.slf4j.Logger;

public final class SplitHinterRegistry {
    private final List<FactorySpec> factorySpecs;

    public SplitHinterRegistry(Map<String, Struct> factoryConf, Logger log) {
        Map loaded = BaseHookLoader.load(IKVRangeSplitHinterFactory.class);
        ArrayList<FactorySpec> specs = new ArrayList<FactorySpec>();
        for (Map.Entry<String, Struct> entry : factoryConf.entrySet()) {
            String fqn = entry.getKey();
            IKVRangeSplitHinterFactory factory = (IKVRangeSplitHinterFactory)loaded.get(fqn);
            if (factory == null) {
                log.warn("KVRangeSplitHinterFactory[{}] not found", (Object)fqn);
                continue;
            }
            log.info("KVRangeSplitHinterFactory[{}] enabled", (Object)fqn);
            specs.add(new FactorySpec(factory, entry.getValue()));
        }
        this.factorySpecs = specs;
    }

    public List<IKVRangeSplitHinter> createHinters(SplitHinterContext context) {
        ArrayList<IKVRangeSplitHinter> hinters = new ArrayList<IKVRangeSplitHinter>();
        for (FactorySpec spec : this.factorySpecs) {
            hinters.add(spec.factory.create(context, spec.conf));
        }
        return hinters;
    }

    private record FactorySpec(IKVRangeSplitHinterFactory factory, Struct conf) {
    }
}

