/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.balance.KVStoreBalanceController;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.server.IBaseKVStoreServer;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.inbox.store.IInboxStore;
import org.apache.bifromq.inbox.store.InboxStoreBuilder;
import org.apache.bifromq.inbox.store.InboxStoreCleaner;
import org.apache.bifromq.inbox.store.InboxStoreCoProcFactory;
import org.apache.bifromq.inbox.store.spi.IInboxStoreBalancerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxStore
implements IInboxStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxStore.class);
    protected final InboxStoreCoProcFactory coProcFactory;
    private final String clusterId;
    private final ExecutorService rpcExecutor;
    private final IBaseKVStoreServer storeServer;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final IBaseKVStoreClient inboxStoreClient;
    private final KVStoreBalanceController balanceController;
    private final AsyncRunner jobRunner;
    private final ScheduledExecutorService jobScheduler;
    private final boolean jobExecutorOwner;
    private final List<IInboxStoreBalancerFactory> effectiveBalancerFactories = new LinkedList<IInboxStoreBalancerFactory>();
    private final InboxStoreCleaner cleaner;

    InboxStore(InboxStoreBuilder builder) {
        this.clusterId = builder.clusterId;
        this.inboxStoreClient = builder.inboxStoreClient;
        this.coProcFactory = new InboxStoreCoProcFactory(builder.distClient, builder.inboxClient, builder.retainClient, builder.sessionDictClient, builder.settingProvider, builder.eventCollector, builder.resourceThrottler, builder.detachTimeout, builder.metaCacheExpireTime, builder.expireRateLimit);
        Map loadedFactories = BaseHookLoader.load(IInboxStoreBalancerFactory.class);
        for (String factoryName : builder.balancerFactoryConfig.keySet()) {
            if (!loadedFactories.containsKey(factoryName)) {
                log.warn("InboxStoreBalancerFactory[{}] not found", (Object)factoryName);
                continue;
            }
            IInboxStoreBalancerFactory balancer = (IInboxStoreBalancerFactory)loadedFactories.get(factoryName);
            balancer.init(builder.balancerFactoryConfig.get(factoryName));
            log.info("InboxStoreBalancerFactory[{}] enabled", (Object)factoryName);
            this.effectiveBalancerFactories.add(balancer);
        }
        this.balanceController = new KVStoreBalanceController(builder.metaService, this.inboxStoreClient, this.effectiveBalancerFactories, builder.bootstrapDelay, builder.zombieProbeDelay, builder.balancerRetryDelay, builder.bgTaskExecutor);
        boolean bl = this.jobExecutorOwner = builder.bgTaskExecutor == null;
        if (this.jobExecutorOwner) {
            String threadName = String.format("inbox-store[%s]-job-executor", builder.clusterId);
            this.jobScheduler = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory(threadName)), (String)threadName, (Tag[])new Tag[0]);
        } else {
            this.jobScheduler = builder.bgTaskExecutor;
        }
        this.jobRunner = new AsyncRunner("job.runner", (Executor)this.jobScheduler, new String[]{"type", "inboxstore"});
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("inbox-store-executor")), (String)"inbox-store-executor", (Tag[])new Tag[0]);
        this.storeServer = IBaseKVStoreServer.builder().rpcServerBuilder(builder.rpcServerBuilder).metaService(builder.metaService).addService(builder.clusterId).coProcFactory((IKVRangeCoProcFactory)this.coProcFactory).storeOptions(builder.storeOptions).agentHost(builder.agentHost).queryExecutor(MoreExecutors.directExecutor()).rpcExecutor((Executor)this.rpcExecutor).tickerThreads(builder.tickerThreads).bgTaskExecutor(builder.bgTaskExecutor).attributes(builder.attributes).finish().build();
        this.cleaner = new InboxStoreCleaner(this.inboxStoreClient, builder.minGCInterval, builder.maxGCInterval, this.jobScheduler);
        this.start();
    }

    @Override
    public String id() {
        return this.storeServer.storeId(this.clusterId);
    }

    private void start() {
        if (this.status.compareAndSet(Status.INIT, Status.STARTING)) {
            log.info("Starting inbox store");
            this.storeServer.start();
            String storeId = this.storeServer.storeId(this.clusterId);
            this.balanceController.start(this.storeServer.storeId(this.clusterId));
            this.status.compareAndSet(Status.STARTING, Status.STARTED);
            this.inboxStoreClient.connState().filter(connState -> connState == IConnectable.ConnState.READY).takeUntil(connState -> connState == IConnectable.ConnState.READY).doOnComplete(() -> this.cleaner.start(storeId)).subscribe();
            log.debug("Inbox store started");
        }
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(Status.STARTED, Status.STOPPING)) {
            log.info("Stopping InboxStore");
            this.jobRunner.awaitDone().toCompletableFuture().join();
            this.cleaner.stop().join();
            this.balanceController.stop();
            this.storeServer.stop();
            log.debug("Stopping CoProcFactory");
            this.coProcFactory.close();
            this.effectiveBalancerFactories.forEach(IInboxStoreBalancerFactory::close);
            if (this.jobExecutorOwner) {
                log.debug("Shutting down job executor");
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.jobScheduler, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            log.debug("InboxStore stopped");
            this.status.compareAndSet(Status.STOPPING, Status.STOPPED);
        }
    }

    private static enum Status {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

