/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Iterator;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.server.scheduler.CheckMatchInfo;
import org.apache.bifromq.inbox.storage.proto.BatchCheckSubReply;
import org.apache.bifromq.inbox.storage.proto.BatchCheckSubRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchCheckSubCall
extends BatchQueryCall<CheckMatchInfo, CheckReply.Code> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchCheckSubCall.class);

    protected BatchCheckSubCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected ROCoProcInput makeBatch(Iterator<CheckMatchInfo> reqIterator) {
        BatchCheckSubRequest.Builder reqBuilder = BatchCheckSubRequest.newBuilder().setNow(HLC.INST.getPhysical());
        reqIterator.forEachRemaining(request -> {
            TenantInboxInstance tenantInboxInstance = TenantInboxInstance.from((String)request.tenantId(), (MatchInfo)request.matchInfo());
            reqBuilder.addParams(BatchCheckSubRequest.Params.newBuilder().setTenantId(tenantInboxInstance.tenantId()).setInboxId(tenantInboxInstance.instance().inboxId()).setIncarnation(tenantInboxInstance.instance().incarnation()).setTopicFilter(request.matchInfo().getMatcher().getMqttTopicFilter()).build());
        });
        long reqId = System.nanoTime();
        return ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setBatchCheckSub(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<CheckMatchInfo, CheckReply.Code, QueryCallBatcherKey>> batchedTasks, ROCoProcOutput output) {
        ICallTask<CheckMatchInfo, CheckReply.Code, QueryCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchCheckSub().getCodeCount());
        int i = 0;
        block5: while ((task = batchedTasks.poll()) != null) {
            BatchCheckSubReply.Code code = output.getInboxService().getBatchCheckSub().getCode(i++);
            switch (code) {
                case OK: {
                    task.resultPromise().complete(CheckReply.Code.OK);
                    continue block5;
                }
                case NO_MATCH: {
                    task.resultPromise().complete(CheckReply.Code.NO_SUB);
                    continue block5;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(CheckReply.Code.NO_RECEIVER);
                    continue block5;
                }
            }
            task.resultPromise().complete(CheckReply.Code.ERROR);
        }
    }

    protected void handleException(ICallTask<CheckMatchInfo, CheckReply.Code, QueryCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(CheckReply.Code.TRY_LATER);
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(CheckReply.Code.TRY_LATER);
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(CheckReply.Code.TRY_LATER);
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

