/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDBCUtils {
    public static String getSubprotocolForURL(String url) {
        StringTokenizer tokeniser = new StringTokenizer(url, ":");
        tokeniser.nextToken();
        return tokeniser.nextToken();
    }

    public static void logWarnings(SQLWarning warning) {
        while (warning != null) {
            NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"052700", (Object[])new Object[]{warning.getMessage()}));
            warning = warning.getNextWarning();
        }
    }

    public static void logWarnings(Connection conn) {
        try {
            JDBCUtils.logWarnings(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"052701", (Object[])new Object[]{conn}), (Throwable)e);
        }
    }

    public static void logWarnings(Statement stmt) {
        try {
            JDBCUtils.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"052702", (Object[])new Object[]{stmt}), (Throwable)e);
        }
    }

    public static void logWarnings(ResultSet rs) {
        try {
            JDBCUtils.logWarnings(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"052703", (Object[])new Object[]{rs}), (Throwable)e);
        }
    }
}

