/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.auto;

import com.github.pagehelper.AutoDialect;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.page.PageAutoDialect;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public abstract class DataSourceAutoDialect<Ds extends DataSource>
implements AutoDialect<String> {
    protected Class dataSourceClass;

    public DataSourceAutoDialect() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        this.dataSourceClass = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public abstract String getJdbcUrl(Ds var1);

    @Override
    public String extractDialectKey(MappedStatement ms, DataSource dataSource, Properties properties) {
        if (this.dataSourceClass.isInstance(dataSource)) {
            return this.getJdbcUrl(dataSource);
        }
        return null;
    }

    @Override
    public AbstractHelperDialect extractDialect(String dialectKey, MappedStatement ms, DataSource dataSource, Properties properties) {
        String dialect = PageAutoDialect.fromJdbcUrl(dialectKey);
        return PageAutoDialect.instanceDialect(dialect, properties);
    }
}

