/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.StringBasedID;

public class SharedStateRegistryKey
extends StringBasedID {
    private static final long serialVersionUID = 1L;

    public SharedStateRegistryKey(String prefix, StateHandleID stateHandleID) {
        super(prefix + '-' + (Object)((Object)stateHandleID));
    }

    @VisibleForTesting
    public SharedStateRegistryKey(String keyString) {
        super(keyString);
    }

    public static SharedStateRegistryKey forStreamStateHandle(StreamStateHandle handle) {
        String keyString = handle.getStreamStateHandleID().getKeyString();
        return new SharedStateRegistryKey(UUID.nameUUIDFromBytes(keyString.getBytes(StandardCharsets.UTF_8)).toString());
    }
}

