/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.JobResultDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobResultSerializer;
import org.apache.flink.runtime.rest.messages.queue.AsynchronouslyCreatedResource;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobExecutionResultResponseBody
implements ResponseBody,
AsynchronouslyCreatedResource<JobResult> {
    @JsonProperty(value="status", required=true)
    private final QueueStatus status;
    @JsonProperty(value="job-execution-result")
    @JsonSerialize(using=JobResultSerializer.class)
    @JsonDeserialize(using=JobResultDeserializer.class)
    @Nullable
    private final JobResult jobExecutionResult;

    @JsonCreator
    public JobExecutionResultResponseBody(@JsonProperty(value="status", required=true) QueueStatus status, @JsonProperty(value="job-execution-result") @JsonDeserialize(using=JobResultDeserializer.class) @Nullable JobResult jobExecutionResult) {
        this.status = Objects.requireNonNull(status);
        this.jobExecutionResult = jobExecutionResult;
    }

    public static JobExecutionResultResponseBody inProgress() {
        return new JobExecutionResultResponseBody(QueueStatus.inProgress(), null);
    }

    public static JobExecutionResultResponseBody created(JobResult jobExecutionResult) {
        return new JobExecutionResultResponseBody(QueueStatus.completed(), jobExecutionResult);
    }

    public QueueStatus getStatus() {
        return this.status;
    }

    @Nullable
    public JobResult getJobExecutionResult() {
        return this.jobExecutionResult;
    }

    @Override
    public QueueStatus queueStatus() {
        return this.status;
    }

    @Override
    public JobResult resource() {
        return this.jobExecutionResult;
    }
}

