/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingResultPartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.PipelinedApproximateSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.SortMergeResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.HsResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.NettyShuffleUtils;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ProcessorArchitecture;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartitionFactory.class);
    private final ResultPartitionManager partitionManager;
    private final FileChannelManager channelManager;
    private final BufferPoolFactory bufferPoolFactory;
    private final BatchShuffleReadBufferPool batchShuffleReadBufferPool;
    private final ScheduledExecutorService batchShuffleReadIOExecutor;
    private final BoundedBlockingSubpartitionType blockingSubpartitionType;
    private final int configuredNetworkBuffersPerChannel;
    private final int floatingNetworkBuffersPerGate;
    private final int networkBufferSize;
    private final boolean batchShuffleCompressionEnabled;
    private final NettyShuffleEnvironmentOptions.CompressionCodec compressionCodec;
    private final int maxBuffersPerChannel;
    private final int sortShuffleMinBuffers;
    private final int sortShuffleMinParallelism;
    private final int hybridShuffleSpilledIndexRegionGroupSize;
    private final long hybridShuffleNumRetainedInMemoryRegionsMax;
    private final boolean sslEnabled;
    private final int maxOverdraftBuffersPerGate;
    private final Optional<TieredResultPartitionFactory> tieredStorage;

    public ResultPartitionFactory(ResultPartitionManager partitionManager, FileChannelManager channelManager, BufferPoolFactory bufferPoolFactory, BatchShuffleReadBufferPool batchShuffleReadBufferPool, ScheduledExecutorService batchShuffleReadIOExecutor, BoundedBlockingSubpartitionType blockingSubpartitionType, int configuredNetworkBuffersPerChannel, int floatingNetworkBuffersPerGate, int networkBufferSize, boolean batchShuffleCompressionEnabled, NettyShuffleEnvironmentOptions.CompressionCodec compressionCodec, int maxBuffersPerChannel, int sortShuffleMinBuffers, int sortShuffleMinParallelism, boolean sslEnabled, int maxOverdraftBuffersPerGate, int hybridShuffleSpilledIndexRegionGroupSize, long hybridShuffleNumRetainedInMemoryRegionsMax, Optional<TieredResultPartitionFactory> tieredStorage) {
        this.partitionManager = partitionManager;
        this.channelManager = channelManager;
        this.configuredNetworkBuffersPerChannel = configuredNetworkBuffersPerChannel;
        this.floatingNetworkBuffersPerGate = floatingNetworkBuffersPerGate;
        this.bufferPoolFactory = bufferPoolFactory;
        this.batchShuffleReadBufferPool = batchShuffleReadBufferPool;
        this.batchShuffleReadIOExecutor = batchShuffleReadIOExecutor;
        this.blockingSubpartitionType = blockingSubpartitionType;
        this.networkBufferSize = networkBufferSize;
        this.batchShuffleCompressionEnabled = batchShuffleCompressionEnabled;
        this.compressionCodec = compressionCodec;
        this.maxBuffersPerChannel = maxBuffersPerChannel;
        this.sortShuffleMinBuffers = sortShuffleMinBuffers;
        this.sortShuffleMinParallelism = sortShuffleMinParallelism;
        this.sslEnabled = sslEnabled;
        this.maxOverdraftBuffersPerGate = maxOverdraftBuffersPerGate;
        this.hybridShuffleSpilledIndexRegionGroupSize = hybridShuffleSpilledIndexRegionGroupSize;
        this.hybridShuffleNumRetainedInMemoryRegionsMax = hybridShuffleNumRetainedInMemoryRegionsMax;
        this.tieredStorage = tieredStorage;
    }

    public ResultPartition create(String taskNameWithSubtaskAndId, int partitionIndex, ResultPartitionDeploymentDescriptor desc) {
        return this.create(taskNameWithSubtaskAndId, partitionIndex, desc.getShuffleDescriptor().getResultPartitionID(), desc.getPartitionType(), desc.getTotalNumberOfPartitions(), desc.getNumberOfSubpartitions(), desc.getMaxParallelism(), desc.isBroadcast(), desc.getShuffleDescriptor(), this.createBufferPoolFactory(desc.getNumberOfSubpartitions(), desc.getPartitionType()), desc.isNumberOfPartitionConsumerUndefined());
    }

    @VisibleForTesting
    public ResultPartition create(String taskNameWithSubtaskAndId, int partitionIndex, ResultPartitionID id, ResultPartitionType type, int numberOfPartitions, int numberOfSubpartitions, int maxParallelism, boolean isBroadcast, ShuffleDescriptor shuffleDescriptor, SupplierWithException<BufferPool, IOException> bufferPoolFactory, boolean isNumberOfPartitionConsumerUndefined) {
        ResultPartition partition;
        BufferCompressor bufferCompressor = null;
        if (type.supportCompression() && this.batchShuffleCompressionEnabled) {
            bufferCompressor = new BufferCompressor(this.networkBufferSize, this.compressionCodec);
        }
        if (this.tieredStorage.isPresent() && type == ResultPartitionType.BLOCKING) {
            LOG.warn("When enabling tiered storage, the BLOCKING result partition will be replaced as HYBRID_FULL.");
            type = ResultPartitionType.HYBRID_FULL;
        }
        ResultSubpartition[] subpartitions = new ResultSubpartition[numberOfSubpartitions];
        if (type == ResultPartitionType.PIPELINED || type == ResultPartitionType.PIPELINED_BOUNDED || type == ResultPartitionType.PIPELINED_APPROXIMATE) {
            PipelinedResultPartition pipelinedPartition = new PipelinedResultPartition(taskNameWithSubtaskAndId, partitionIndex, id, type, subpartitions, maxParallelism, this.partitionManager, bufferCompressor, bufferPoolFactory);
            for (int i = 0; i < subpartitions.length; ++i) {
                subpartitions[i] = type == ResultPartitionType.PIPELINED_APPROXIMATE ? new PipelinedApproximateSubpartition(i, this.configuredNetworkBuffersPerChannel, pipelinedPartition) : new PipelinedSubpartition(i, this.configuredNetworkBuffersPerChannel, pipelinedPartition);
            }
            partition = pipelinedPartition;
        } else if (type == ResultPartitionType.BLOCKING || type == ResultPartitionType.BLOCKING_PERSISTENT) {
            if (numberOfSubpartitions >= this.sortShuffleMinParallelism) {
                partition = new SortMergeResultPartition(taskNameWithSubtaskAndId, partitionIndex, id, type, subpartitions.length, maxParallelism, this.batchShuffleReadBufferPool, this.batchShuffleReadIOExecutor, this.partitionManager, this.channelManager.createChannel().getPath(), bufferCompressor, bufferPoolFactory);
            } else {
                BoundedBlockingResultPartition blockingPartition = new BoundedBlockingResultPartition(taskNameWithSubtaskAndId, partitionIndex, id, type, subpartitions, maxParallelism, this.partitionManager, bufferCompressor, bufferPoolFactory);
                ResultPartitionFactory.initializeBoundedBlockingPartitions(subpartitions, blockingPartition, this.blockingSubpartitionType, this.networkBufferSize, this.channelManager, this.sslEnabled);
                partition = blockingPartition;
            }
        } else if (type == ResultPartitionType.HYBRID_FULL || type == ResultPartitionType.HYBRID_SELECTIVE) {
            Preconditions.checkState((boolean)(shuffleDescriptor instanceof NettyShuffleDescriptor));
            partition = this.tieredStorage.isPresent() ? this.tieredStorage.get().createTieredResultPartition(taskNameWithSubtaskAndId, partitionIndex, id, type, numberOfPartitions, subpartitions.length, maxParallelism, this.networkBufferSize, isBroadcast, this.partitionManager, bufferCompressor, (List)Preconditions.checkNotNull(((NettyShuffleDescriptor)shuffleDescriptor).getTierShuffleDescriptors()), bufferPoolFactory, this.channelManager, this.batchShuffleReadBufferPool, this.batchShuffleReadIOExecutor, isNumberOfPartitionConsumerUndefined) : new HsResultPartition(taskNameWithSubtaskAndId, partitionIndex, id, type, subpartitions.length, maxParallelism, this.batchShuffleReadBufferPool, this.batchShuffleReadIOExecutor, this.partitionManager, this.channelManager.createChannel().getPath(), this.networkBufferSize, this.getHybridShuffleConfiguration(numberOfSubpartitions, type), bufferCompressor, isBroadcast, bufferPoolFactory);
        } else {
            throw new IllegalArgumentException("Unrecognized ResultPartitionType: " + (Object)((Object)type));
        }
        partition.isNumberOfPartitionConsumerUndefined(isNumberOfPartitionConsumerUndefined);
        LOG.debug("{}: Initialized {}", (Object)taskNameWithSubtaskAndId, (Object)this);
        return partition;
    }

    private HybridShuffleConfiguration getHybridShuffleConfiguration(int numberOfSubpartitions, ResultPartitionType resultPartitionType) {
        return HybridShuffleConfiguration.builder(numberOfSubpartitions, this.batchShuffleReadBufferPool.getNumBuffersPerRequest()).setSpillingStrategyType(resultPartitionType == ResultPartitionType.HYBRID_FULL ? HybridShuffleConfiguration.SpillingStrategyType.FULL : HybridShuffleConfiguration.SpillingStrategyType.SELECTIVE).setRegionGroupSizeInBytes(this.hybridShuffleSpilledIndexRegionGroupSize).setNumRetainedInMemoryRegionsMax(this.hybridShuffleNumRetainedInMemoryRegionsMax).build();
    }

    private static void initializeBoundedBlockingPartitions(ResultSubpartition[] subpartitions, BoundedBlockingResultPartition parent, BoundedBlockingSubpartitionType blockingSubpartitionType, int networkBufferSize, FileChannelManager channelManager, boolean sslEnabled) {
        int i = 0;
        try {
            for (i = 0; i < subpartitions.length; ++i) {
                File spillFile = channelManager.createChannel().getPathFile();
                subpartitions[i] = blockingSubpartitionType.create(i, parent, spillFile, networkBufferSize, sslEnabled);
            }
        }
        catch (IOException e) {
            ResultPartitionFactory.releasePartitionsQuietly(subpartitions, i);
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    private static void releasePartitionsQuietly(ResultSubpartition[] partitions, int until) {
        for (int i = 0; i < until; ++i) {
            ResultSubpartition subpartition = partitions[i];
            ExceptionUtils.suppressExceptions(subpartition::release);
        }
    }

    private static boolean isOverdraftBufferNeeded(ResultPartitionType resultPartitionType) {
        return resultPartitionType.isPipelinedOrPipelinedBoundedResultPartition();
    }

    @VisibleForTesting
    SupplierWithException<BufferPool, IOException> createBufferPoolFactory(int numberOfSubpartitions, ResultPartitionType type) {
        return () -> {
            Pair<Integer, Integer> pair = NettyShuffleUtils.getMinMaxNetworkBuffersPerResultPartition(this.configuredNetworkBuffersPerChannel, this.floatingNetworkBuffersPerGate, this.sortShuffleMinParallelism, this.sortShuffleMinBuffers, numberOfSubpartitions, this.tieredStorage.isPresent(), this.tieredStorage.map(ResultPartitionFactory::getNumTotalGuaranteedBuffers).orElse(0), type);
            return this.bufferPoolFactory.createBufferPool((Integer)pair.getLeft(), (Integer)pair.getRight(), numberOfSubpartitions, this.maxBuffersPerChannel, ResultPartitionFactory.isOverdraftBufferNeeded(type) ? this.maxOverdraftBuffersPerGate : 0);
        };
    }

    static BoundedBlockingSubpartitionType getBoundedBlockingType() {
        switch (ProcessorArchitecture.getMemoryAddressSize()) {
            case _64_BIT: {
                return BoundedBlockingSubpartitionType.FILE_MMAP;
            }
            case _32_BIT: {
                return BoundedBlockingSubpartitionType.FILE;
            }
        }
        LOG.warn("Cannot determine memory architecture. Using pure file-based shuffle.");
        return BoundedBlockingSubpartitionType.FILE;
    }

    private static int getNumTotalGuaranteedBuffers(TieredResultPartitionFactory resultPartitionFactory) {
        return resultPartitionFactory.getTieredStorageConfiguration().getTierFactories().stream().map(TierFactory::getProducerAgentMemorySpec).map(TieredStorageMemorySpec::getNumGuaranteedBuffers).mapToInt(Integer::intValue).sum();
    }
}

