/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.InitializationStatus;
import org.apache.flink.util.Preconditions;

public class SubTaskInitializationMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long UNSET = -1L;
    private final long startTs;
    private final long endTs;
    private final Map<String, Long> durationMetrics;
    private final InitializationStatus status;

    public SubTaskInitializationMetrics(long startTs, long endTs, Map<String, Long> durationMetrics, InitializationStatus status) {
        Preconditions.checkArgument((startTs >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((endTs >= startTs ? 1 : 0) != 0);
        this.startTs = startTs;
        this.endTs = endTs;
        this.durationMetrics = durationMetrics;
        this.status = status;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public Map<String, Long> getDurationMetrics() {
        return this.durationMetrics;
    }

    public InitializationStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubTaskInitializationMetrics that = (SubTaskInitializationMetrics)o;
        return this.startTs == that.startTs && this.endTs == that.endTs && Objects.equals(this.durationMetrics, that.durationMetrics) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTs, this.endTs, this.durationMetrics, this.status});
    }

    public String toString() {
        return SubTaskInitializationMetrics.class.getSimpleName() + "{initializationStartTs=" + this.startTs + "initializationEndTs=" + this.endTs + "durationMetrics=" + this.durationMetrics + "status=" + (Object)((Object)this.status) + '}';
    }
}

