/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.EpochManager;
import org.apache.flink.runtime.asyncprocessing.KeyAccountingUnit;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.StateExecutor;
import org.apache.flink.runtime.asyncprocessing.StateFutureFactory;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestBuffer;
import org.apache.flink.runtime.asyncprocessing.StateRequestContainer;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutionController<K>
implements StateRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncExecutionController.class);
    private final int batchSize;
    private final long bufferTimeout;
    private final int maxInFlightRecordNum;
    private final MailboxExecutor mailboxExecutor;
    private final StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler;
    final KeyAccountingUnit<K> keyAccountingUnit;
    private final StateFutureFactory<K> stateFutureFactory;
    private final StateExecutor stateExecutor;
    RecordContext<K> currentContext;
    StateRequestBuffer<K> stateRequestsBuffer;
    final AtomicInteger inFlightRecordNum;
    private final int maxParallelism;
    final EpochManager epochManager;
    final EpochManager.ParallelMode epochParallelMode = EpochManager.ParallelMode.SERIAL_BETWEEN_EPOCH;

    public AsyncExecutionController(MailboxExecutor mailboxExecutor, StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler, StateExecutor stateExecutor, int maxParallelism, int batchSize, long bufferTimeout, int maxInFlightRecords) {
        this.keyAccountingUnit = new KeyAccountingUnit(maxInFlightRecords);
        this.mailboxExecutor = mailboxExecutor;
        this.exceptionHandler = exceptionHandler;
        this.stateFutureFactory = new StateFutureFactory(this, mailboxExecutor, exceptionHandler);
        this.stateExecutor = stateExecutor;
        this.batchSize = batchSize;
        this.bufferTimeout = bufferTimeout;
        this.maxInFlightRecordNum = maxInFlightRecords;
        this.inFlightRecordNum = new AtomicInteger(0);
        this.maxParallelism = maxParallelism;
        this.stateRequestsBuffer = new StateRequestBuffer(bufferTimeout, scheduledSeq -> mailboxExecutor.execute(() -> {
            if (this.stateRequestsBuffer.checkCurrentSeq((long)scheduledSeq)) {
                this.triggerIfNeeded(true);
            }
        }, "AEC-buffer-timeout"));
        this.epochManager = new EpochManager(this);
        LOG.info("Create AsyncExecutionController: batchSize {}, bufferTimeout {}, maxInFlightRecordNum {}, epochParallelMode {}", new Object[]{this.batchSize, this.bufferTimeout, this.maxInFlightRecordNum, this.epochParallelMode});
    }

    public RecordContext<K> buildContext(Object record, K key) {
        if (record == null) {
            return new RecordContext<K>(RecordContext.EMPTY_RECORD, key, this::disposeContext, KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism), this.epochManager.onRecord());
        }
        return new RecordContext<K>(record, key, this::disposeContext, KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism), this.epochManager.onRecord());
    }

    public void setCurrentContext(RecordContext<K> switchingContext) {
        this.currentContext = switchingContext;
    }

    void disposeContext(RecordContext<K> toDispose) {
        this.epochManager.completeOneRecord(toDispose.getEpoch());
        this.keyAccountingUnit.release(toDispose.getRecord(), toDispose.getKey());
        this.inFlightRecordNum.decrementAndGet();
        RecordContext<K> nextRecordCtx = this.stateRequestsBuffer.tryActivateOneByKey(toDispose.getKey());
        if (nextRecordCtx != null) {
            Preconditions.checkState((boolean)this.tryOccupyKey(nextRecordCtx), (Object)String.format("key(%s) is already occupied.", nextRecordCtx.getKey()));
        }
    }

    boolean tryOccupyKey(RecordContext<K> recordContext) {
        boolean occupied = recordContext.isKeyOccupied();
        if (!occupied && this.keyAccountingUnit.occupy(recordContext.getRecord(), recordContext.getKey())) {
            recordContext.setKeyOccupied();
            occupied = true;
        }
        return occupied;
    }

    @Override
    public <IN, OUT> InternalStateFuture<OUT> handleRequest(@Nullable State state, StateRequestType type, @Nullable IN payload) {
        InternalStateFuture stateFuture = this.stateFutureFactory.create(this.currentContext);
        StateRequest request = new StateRequest(state, type, payload, stateFuture, this.currentContext);
        this.seizeCapacity();
        if (this.tryOccupyKey(this.currentContext)) {
            this.insertActiveBuffer(request);
        } else {
            this.insertBlockingBuffer(request);
        }
        this.triggerIfNeeded(false);
        return stateFuture;
    }

    <IN, OUT> void insertActiveBuffer(StateRequest<K, IN, OUT> request) {
        this.stateRequestsBuffer.enqueueToActive(request);
    }

    <IN, OUT> void insertBlockingBuffer(StateRequest<K, IN, OUT> request) {
        this.stateRequestsBuffer.enqueueToBlocking(request);
    }

    public void triggerIfNeeded(boolean force) {
        if (!force && this.stateRequestsBuffer.activeQueueSize() < this.batchSize) {
            return;
        }
        Optional<StateRequestContainer> toRun = this.stateRequestsBuffer.popActive(this.batchSize, () -> this.stateExecutor.createStateRequestContainer());
        if (!toRun.isPresent() || toRun.get().isEmpty()) {
            return;
        }
        this.stateExecutor.executeBatchRequests(toRun.get());
        this.stateRequestsBuffer.advanceSeq();
    }

    private void seizeCapacity() {
        if (this.currentContext.isKeyOccupied()) {
            return;
        }
        RecordContext<K> storedContext = this.currentContext;
        this.drainInflightRecords(this.maxInFlightRecordNum);
        this.setCurrentContext(storedContext);
        this.inFlightRecordNum.incrementAndGet();
    }

    public void syncPointRequestWithCallback(ThrowingRunnable<Exception> callback) {
        this.handleRequest(null, StateRequestType.SYNC_POINT, null).thenAccept(v -> callback.run());
    }

    public void drainInflightRecords(int targetNum) {
        try {
            while (this.inFlightRecordNum.get() > targetNum) {
                if (this.mailboxExecutor.tryYield()) continue;
                this.triggerIfNeeded(true);
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void processNonRecord(ThrowingRunnable<? extends Exception> action) {
        Runnable wrappedAction = () -> {
            try {
                action.run();
            }
            catch (Exception e) {
                this.exceptionHandler.handleException("Failed to process non-record.", (Throwable)e);
            }
        };
        this.epochManager.onNonRecord(wrappedAction, this.epochParallelMode);
    }

    @VisibleForTesting
    public StateExecutor getStateExecutor() {
        return this.stateExecutor;
    }

    @VisibleForTesting
    public int getInFlightRecordNum() {
        return this.inFlightRecordNum.get();
    }
}

