/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.BroadcastStream;
import org.apache.flink.datastream.api.stream.GlobalStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.api.stream.ProcessConfigurable;
import org.apache.flink.datastream.impl.operators.KeyedProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoInputNonBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoOutputProcessOperator;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.BroadcastStreamImpl;
import org.apache.flink.datastream.impl.stream.GlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.NonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.utils.StreamUtils;
import org.apache.flink.streaming.api.transformations.DataStreamV2SinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class KeyedPartitionStreamImpl<K, V>
extends AbstractDataStream<V>
implements KeyedPartitionStream<K, V> {
    private final KeySelector<V, K> keySelector;
    private final TypeInformation<K> keyType;

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, KeySelector<V, K> keySelector) {
        this(dataStream, keySelector, TypeExtractor.getKeySelectorTypes(keySelector, dataStream.getType()));
    }

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, KeySelector<V, K> keySelector, TypeInformation<K> keyType) {
        this(dataStream, (Transformation<V>)new PartitionTransformation(dataStream.getTransformation(), (StreamPartitioner)new KeyGroupStreamPartitioner(keySelector, 128)), keySelector, keyType);
    }

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, Transformation<V> partitionTransformation, KeySelector<V, K> keySelector, TypeInformation<K> keyType) {
        super(dataStream.getEnvironment(), partitionTransformation);
        this.keySelector = keySelector;
        this.keyType = keyType;
    }

    public <OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> process(OneInputStreamProcessFunction<V, OUT> processFunction) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        KeyedProcessOperator operator = new KeyedProcessOperator(processFunction);
        OneInputTransformation<V, OUT> transform = StreamUtils.getOneInputKeyedTransformation("KeyedProcess", this, outType, operator, this.keySelector, this.keyType);
        this.environment.addOperator((Transformation<?>)transform);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, transform));
    }

    public <OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> process(OneInputStreamProcessFunction<V, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        KeyedProcessOperator operator = new KeyedProcessOperator(processFunction, (KeySelector)Preconditions.checkNotNull(newKeySelector));
        OneInputTransformation<V, OUT> transform = StreamUtils.getOneInputKeyedTransformation("KeyedProcess", this, outType, operator, this.keySelector, this.keyType);
        NonKeyedPartitionStreamImpl outputStream = new NonKeyedPartitionStreamImpl(this.environment, transform);
        this.environment.addOperator((Transformation<?>)transform);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(outputStream, transform, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, outputStream.getType())));
    }

    public <OUT1, OUT2> KeyedPartitionStream.TwoKeyedPartitionStreams<K, OUT1, OUT2> process(TwoOutputStreamProcessFunction<V, OUT1, OUT2> processFunction, KeySelector<OUT1, K> keySelector1, KeySelector<OUT2, K> keySelector2) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        KeyedTwoOutputProcessOperator<K, V, OUT1, OUT2> operator = new KeyedTwoOutputProcessOperator<K, V, OUT1, OUT2>(processFunction, secondOutputTag, keySelector1, keySelector2);
        OneInputTransformation mainOutputTransform = StreamUtils.getOneInputKeyedTransformation("Two-Output-Process", this, firstOutputType, operator, this.keySelector, this.keyType);
        NonKeyedPartitionStreamImpl nonKeyedMainOutputStream = new NonKeyedPartitionStreamImpl(this.environment, mainOutputTransform);
        Transformation sideOutputTransform = nonKeyedMainOutputStream.getSideOutputTransform(secondOutputTag);
        NonKeyedPartitionStreamImpl nonKeyedSideStream = new NonKeyedPartitionStreamImpl(this.environment, sideOutputTransform);
        KeyedPartitionStreamImpl keyedMainOutputStream = new KeyedPartitionStreamImpl(nonKeyedMainOutputStream, mainOutputTransform, keySelector1, TypeExtractor.getKeySelectorTypes(keySelector1, nonKeyedMainOutputStream.getType()));
        KeyedPartitionStreamImpl keyedSideOutputStream = new KeyedPartitionStreamImpl(nonKeyedSideStream, sideOutputTransform, keySelector2, TypeExtractor.getKeySelectorTypes(keySelector2, nonKeyedSideStream.getType()));
        this.environment.addOperator((Transformation<?>)mainOutputTransform);
        return TwoKeyedPartitionStreamsImpl.of(keyedMainOutputStream, keyedSideOutputStream);
    }

    public <OUT1, OUT2> NonKeyedPartitionStream.TwoNonKeyedPartitionStreams<OUT1, OUT2> process(TwoOutputStreamProcessFunction<V, OUT1, OUT2> processFunction) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        KeyedTwoOutputProcessOperator operator = new KeyedTwoOutputProcessOperator(processFunction, secondOutputTag);
        OneInputTransformation firstTransformation = StreamUtils.getOneInputKeyedTransformation("Two-Output-Process", this, firstOutputType, operator, this.keySelector, this.keyType);
        NonKeyedPartitionStreamImpl firstStream = new NonKeyedPartitionStreamImpl(this.environment, firstTransformation);
        NonKeyedPartitionStreamImpl secondStream = new NonKeyedPartitionStreamImpl(this.environment, firstStream.getSideOutputTransform(secondOutputTag));
        this.environment.addOperator((Transformation<?>)firstTransformation);
        return NonKeyedPartitionStreamImpl.TwoNonKeyedPartitionStreamsImpl.of(firstStream, secondStream);
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((KeyedPartitionStreamImpl)other).getType());
        KeyedTwoInputNonBroadcastProcessOperator processOperator = new KeyedTwoInputNonBroadcastProcessOperator(processFunction);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Process", this, (KeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((KeyedPartitionStreamImpl)other).getType());
        KeyedTwoInputNonBroadcastProcessOperator<K, V, T_OTHER, OUT> processOperator = new KeyedTwoInputNonBroadcastProcessOperator<K, V, T_OTHER, OUT>(processFunction, newKeySelector);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Process", this, (KeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        NonKeyedPartitionStreamImpl nonKeyedOutputStream = new NonKeyedPartitionStreamImpl(this.environment, outTransformation);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(nonKeyedOutputStream, outTransformation, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, nonKeyedOutputStream.getType())));
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Broadcast-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction, (KeySelector)Preconditions.checkNotNull(newKeySelector));
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Broadcast-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        NonKeyedPartitionStreamImpl outputStream = new NonKeyedPartitionStreamImpl(this.environment, outTransformation);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(outputStream, outTransformation, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, outputStream.getType())));
    }

    public TypeInformation<K> getKeyType() {
        return this.keyType;
    }

    public KeySelector<V, K> getKeySelector() {
        return this.keySelector;
    }

    public ProcessConfigurable<?> toSink(Sink<V> sink) {
        DataStreamV2SinkTransformation<V, V> sinkTransformation = StreamUtils.addSinkOperator(this, sink, this.getType());
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, sinkTransformation));
    }

    public GlobalStream<V> global() {
        return new GlobalStreamImpl(this.environment, new PartitionTransformation(this.transformation, (StreamPartitioner)new GlobalPartitioner()));
    }

    public <NEW_KEY> KeyedPartitionStream<NEW_KEY, V> keyBy(KeySelector<V, NEW_KEY> keySelector) {
        return new KeyedPartitionStreamImpl<NEW_KEY, V>(this, keySelector);
    }

    public NonKeyedPartitionStream<V> shuffle() {
        return new NonKeyedPartitionStreamImpl(this.environment, new PartitionTransformation(this.getTransformation(), (StreamPartitioner)new ShufflePartitioner()));
    }

    public BroadcastStream<V> broadcast() {
        return new BroadcastStreamImpl(this.environment, this.getTransformation());
    }

    static class TwoKeyedPartitionStreamsImpl<K, OUT1, OUT2>
    implements KeyedPartitionStream.TwoKeyedPartitionStreams<K, OUT1, OUT2> {
        private final KeyedPartitionStreamImpl<K, OUT1> firstStream;
        private final KeyedPartitionStreamImpl<K, OUT2> secondStream;

        public static <K, OUT1, OUT2> TwoKeyedPartitionStreamsImpl<K, OUT1, OUT2> of(KeyedPartitionStreamImpl<K, OUT1> firstStream, KeyedPartitionStreamImpl<K, OUT2> secondStream) {
            return new TwoKeyedPartitionStreamsImpl<K, OUT1, OUT2>(firstStream, secondStream);
        }

        private TwoKeyedPartitionStreamsImpl(KeyedPartitionStreamImpl<K, OUT1> firstStream, KeyedPartitionStreamImpl<K, OUT2> secondStream) {
            this.firstStream = firstStream;
            this.secondStream = secondStream;
        }

        public KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT1> getFirst() {
            return StreamUtils.wrapWithConfigureHandle(this.firstStream);
        }

        public KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT2> getSecond() {
            return StreamUtils.wrapWithConfigureHandle(this.secondStream);
        }
    }
}

