/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.concurrent.ExecutorService;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergThreadPools {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergThreadPools.class);
    private static volatile ExecutorService planningExecutor;
    private static volatile ExecutorService commitExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void init(int planningThreadPoolSize, int commitThreadPoolSize) {
        Class<IcebergThreadPools> clazz;
        if (planningExecutor == null) {
            clazz = IcebergThreadPools.class;
            // MONITORENTER : org.apache.amoro.utils.IcebergThreadPools.class
            if (planningExecutor == null) {
                planningExecutor = ThreadPools.newWorkerPool((String)"iceberg-planning-pool", (int)planningThreadPoolSize);
            }
            // MONITOREXIT : clazz
        }
        if (commitExecutor == null) {
            clazz = IcebergThreadPools.class;
            // MONITORENTER : org.apache.amoro.utils.IcebergThreadPools.class
            if (commitExecutor == null) {
                commitExecutor = ThreadPools.newWorkerPool((String)"iceberg-commit-pool", (int)commitThreadPoolSize);
            }
            // MONITOREXIT : clazz
        }
        LOG.info("init iceberg thread pool success, planningExecutor size:{},commitExecutor size:{}", (Object)planningThreadPoolSize, (Object)commitThreadPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getPlanningExecutor() {
        if (planningExecutor != null) return planningExecutor;
        Class<IcebergThreadPools> clazz = IcebergThreadPools.class;
        synchronized (IcebergThreadPools.class) {
            if (planningExecutor != null) return planningExecutor;
            planningExecutor = ThreadPools.newWorkerPool((String)"iceberg-planning-pool", (int)Runtime.getRuntime().availableProcessors());
            // ** MonitorExit[var0] (shouldn't be in output)
            return planningExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getCommitExecutor() {
        if (commitExecutor != null) return commitExecutor;
        Class<IcebergThreadPools> clazz = IcebergThreadPools.class;
        synchronized (IcebergThreadPools.class) {
            if (commitExecutor != null) return commitExecutor;
            commitExecutor = ThreadPools.newWorkerPool((String)"iceberg-commit-pool", (int)Runtime.getRuntime().availableProcessors());
            // ** MonitorExit[var0] (shouldn't be in output)
            return commitExecutor;
        }
    }
}

