/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.iceberg.util.LockManagers;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergInMemoryLockManager
extends LockManagers.BaseLockManager {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergInMemoryLockManager.class);
    private static final Map<String, InMemoryLockContent> LOCKS = Maps.newConcurrentMap();
    private static final Map<String, ScheduledFuture<?>> HEARTBEATS = Maps.newHashMap();
    private static final IcebergInMemoryLockManager INSTANCE = new IcebergInMemoryLockManager(Maps.newHashMap());

    public static IcebergInMemoryLockManager instance() {
        return INSTANCE;
    }

    IcebergInMemoryLockManager(Map<String, String> properties) {
        this.initialize(properties);
    }

    @VisibleForTesting
    void acquireOnce(String entityId, String ownerId) {
        InMemoryLockContent previous;
        InMemoryLockContent content = LOCKS.get(entityId);
        if (content != null && content.expireMs() > System.currentTimeMillis()) {
            throw new IllegalStateException(String.format("Lock for %s currently held by %s, expiration: %s", entityId, content.ownerId(), content.expireMs()));
        }
        long expiration = System.currentTimeMillis() + this.heartbeatTimeoutMs();
        boolean succeed = content == null ? (previous = LOCKS.putIfAbsent(entityId, new InMemoryLockContent(ownerId, expiration))) == null : LOCKS.replace(entityId, content, new InMemoryLockContent(ownerId, expiration));
        if (succeed) {
            if (HEARTBEATS.containsKey(entityId)) {
                HEARTBEATS.remove(entityId).cancel(false);
            }
        } else {
            throw new IllegalStateException("Unable to acquire lock " + entityId);
        }
        HEARTBEATS.put(entityId, this.scheduler().scheduleAtFixedRate(() -> {
            InMemoryLockContent lastContent = LOCKS.get(entityId);
            try {
                long newExpiration = System.currentTimeMillis() + this.heartbeatTimeoutMs();
                LOCKS.replace(entityId, lastContent, new InMemoryLockContent(ownerId, newExpiration));
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Cannot heartbeat to a deleted lock " + entityId, e);
            }
        }, 0L, this.heartbeatIntervalMs(), TimeUnit.MILLISECONDS));
    }

    public boolean acquire(String entityId, String ownerId) {
        try {
            Tasks.foreach((Object[])new String[]{entityId}).retry(0x7FFFFFFE).onlyRetryOn(IllegalStateException.class).throwFailureWhenFinished().exponentialBackoff(this.acquireIntervalMs(), this.acquireIntervalMs(), this.acquireTimeoutMs(), 1.0).run(id -> this.acquireOnce((String)id, ownerId));
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public boolean release(String entityId, String ownerId) {
        InMemoryLockContent currentContent = LOCKS.get(entityId);
        if (currentContent == null) {
            LOG.error("Cannot find lock for entity {}", (Object)entityId);
            return false;
        }
        if (!currentContent.ownerId().equals(ownerId)) {
            LOG.error("Cannot unlock {} by {}, current owner: {}", new Object[]{entityId, ownerId, currentContent.ownerId()});
            return false;
        }
        Optional.ofNullable(HEARTBEATS.remove(entityId)).ifPresent(future -> future.cancel(false));
        LOCKS.remove(entityId);
        return true;
    }

    public void close() {
        HEARTBEATS.values().forEach(future -> future.cancel(false));
        HEARTBEATS.clear();
        LOCKS.clear();
    }

    private static class InMemoryLockContent {
        private final String ownerId;
        private final long expireMs;

        InMemoryLockContent(String ownerId, long expireMs) {
            this.ownerId = ownerId;
            this.expireMs = expireMs;
        }

        public long expireMs() {
            return this.expireMs;
        }

        public String ownerId() {
            return this.ownerId;
        }
    }
}

