/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.List;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.io.writer.GenericTaskWriters;
import org.apache.amoro.io.writer.MixedTreeNodePosDeleteWriter;
import org.apache.amoro.optimizing.AbstractRewriteFilesExecutor;
import org.apache.amoro.optimizing.MixedIcebergOptimizingDataReader;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.TaskWriter;

public class MixedIcebergRewriteExecutor
extends AbstractRewriteFilesExecutor {
    public MixedIcebergRewriteExecutor(RewriteFilesInput input, MixedTable table, StructLikeCollections structLikeCollections, String outputDir) {
        super(input, table, structLikeCollections);
    }

    @Override
    protected OptimizingDataReader dataReader() {
        return new MixedIcebergOptimizingDataReader(this.table, this.structLikeCollections, this.input);
    }

    @Override
    protected FileWriter<PositionDelete<Record>, DeleteWriteResult> posWriter() {
        FileAppenderFactory<Record> appenderFactory = this.fullMetricAppenderFactory(this.table.spec());
        return new MixedTreeNodePosDeleteWriter<Record>(appenderFactory, this.deleteFileFormat(), this.partition(), this.io, this.encryptionManager(), this.getTransactionId(this.input.rePosDeletedDataFilesForMixed()), this.baseLocation(), this.table.spec());
    }

    @Override
    protected TaskWriter<Record> dataWriter() {
        return GenericTaskWriters.builderFor(this.table).withTransactionId(this.table.isKeyedTable() ? Long.valueOf(this.getTransactionId(this.input.rewrittenDataFilesForMixed())) : null).withTaskId(0).withTargetFileSize(this.targetSize()).buildBaseWriter();
    }

    private long getTransactionId(List<PrimaryKeyedFile> dataFiles) {
        return dataFiles.stream().mapToLong(PrimaryKeyedFile::transactionId).max().orElse(0L);
    }

    private String baseLocation() {
        if (this.table.isKeyedTable()) {
            return this.table.asKeyedTable().baseTable().location();
        }
        return this.table.asUnkeyedTable().location();
    }
}

