/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.function.Supplier;
import org.apache.amoro.op.MixedUpdate;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;

public class MixedAppendFiles
extends MixedUpdate<AppendFiles>
implements AppendFiles {
    private final AppendFiles appendFiles;

    public static Builder buildFor(MixedTable table, boolean fastAppend) {
        return new Builder(table, fastAppend);
    }

    private MixedAppendFiles(MixedTable mixedTable, AppendFiles appendFiles) {
        super(mixedTable, appendFiles);
        this.appendFiles = appendFiles;
    }

    private MixedAppendFiles(MixedTable mixedTable, AppendFiles appendFiles, Transaction transaction, boolean autoCommitTransaction) {
        super(mixedTable, appendFiles, transaction, autoCommitTransaction);
        this.appendFiles = appendFiles;
    }

    public AppendFiles appendFile(DataFile file) {
        this.appendFiles.appendFile(file);
        this.addIcebergDataFile(file);
        return this;
    }

    public AppendFiles appendManifest(ManifestFile file) {
        this.appendFiles.appendManifest(file);
        return this;
    }

    @Override
    protected AppendFiles self() {
        return this;
    }

    public static class Builder
    extends MixedUpdate.Builder<MixedAppendFiles, AppendFiles> {
        private final boolean fastAppend;

        private Builder(MixedTable table, boolean fastAppend) {
            super(table);
            this.generateWatermark();
            this.fastAppend = fastAppend;
        }

        @Override
        protected MixedAppendFiles updateWithWatermark(Transaction transaction, boolean autoCommitTransaction) {
            return new MixedAppendFiles(this.table, this.newAppendFiles(transaction), transaction, autoCommitTransaction);
        }

        @Override
        protected Supplier<AppendFiles> transactionDelegateSupplier(Transaction transaction) {
            return () -> this.newAppendFiles(transaction);
        }

        @Override
        protected Supplier<AppendFiles> tableStoreDelegateSupplier(Table tableStore) {
            return () -> this.newAppendFiles(tableStore);
        }

        @Override
        protected MixedAppendFiles updateWithoutWatermark(Supplier<AppendFiles> delegateSupplier) {
            return new MixedAppendFiles(this.table, delegateSupplier.get());
        }

        private AppendFiles newAppendFiles(Transaction transaction) {
            if (this.fastAppend) {
                return transaction.newFastAppend();
            }
            return transaction.newAppend();
        }

        private AppendFiles newAppendFiles(Table tableStore) {
            if (this.fastAppend) {
                return tableStore.newFastAppend();
            }
            return tableStore.newAppend();
        }
    }
}

