/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;

public class IcebergFanoutPosDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private final List<DeleteFile> completedFiles = Lists.newArrayList();
    private final Map<CharSequenceWrapper, List<PosRow<T>>> posDeletes = Maps.newHashMap();
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private final CharSequenceWrapper wrapper = CharSequenceWrapper.wrap(null);
    private final FileAppenderFactory<T> appenderFactory;
    private final FileFormat format;
    private final StructLike partition;
    private final FileIO fileIO;
    private final EncryptionManager encryptionManager;
    private final String fileNameSuffix;
    private boolean closed = false;
    private Throwable failure;

    public IcebergFanoutPosDeleteWriter(FileAppenderFactory<T> appenderFactory, FileFormat format, StructLike partition, FileIO fileIO, EncryptionManager encryptionManager, String fileNameSuffix) {
        this.appenderFactory = appenderFactory;
        this.format = format;
        this.partition = partition;
        this.fileIO = fileIO;
        this.encryptionManager = encryptionManager;
        this.fileNameSuffix = fileNameSuffix;
    }

    protected void setFailure(Throwable throwable) {
        if (this.failure == null) {
            this.failure = throwable;
        }
    }

    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    public void write(PositionDelete<T> payload) {
        this.delete(payload.path(), payload.pos(), payload.row());
    }

    public void delete(CharSequence path, long pos) {
        this.delete(path, pos, null);
    }

    public void delete(CharSequence path, long pos, T row) {
        List<PosRow<T>> posRows = this.posDeletes.get(this.wrapper.set(path));
        if (posRows != null) {
            posRows.add(PosRow.of(pos, row));
        } else {
            this.posDeletes.put(CharSequenceWrapper.wrap((CharSequence)path), Lists.newArrayList((Object[])new PosRow[]{PosRow.of(pos, row)}));
        }
    }

    public List<DeleteFile> complete() throws IOException {
        this.close();
        Preconditions.checkState((this.failure == null ? 1 : 0) != 0, (String)"Cannot return results from failed writer", (Object)this.failure);
        return this.completedFiles;
    }

    public CharSequenceSet referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flushDeletes();
        }
    }

    public DeleteWriteResult result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot get result from unclosed writer");
        return new DeleteWriteResult(this.completedFiles, this.referencedDataFiles);
    }

    private void flushDeletes() {
        if (this.posDeletes.isEmpty()) {
            return;
        }
        this.posDeletes.forEach((filePath, posDeletes) -> {
            if (posDeletes.size() <= 0) {
                return;
            }
            posDeletes.sort(Comparator.comparingLong(PosRow::pos));
            String fileName = TableFileUtil.getFileNameWithoutExt(filePath.get().toString());
            String fileDir = TableFileUtil.getFileDir(filePath.get().toString());
            String deleteFilePath = this.format.addExtension(String.format("%s/%s", fileDir, TableFileUtil.optimizingPosDeleteFileName(fileName, this.fileNameSuffix)));
            EncryptedOutputFile outputFile = this.encryptionManager.encrypt(this.fileIO.newOutputFile(deleteFilePath));
            PositionDeleteWriter writer = this.appenderFactory.newPosDeleteWriter(outputFile, this.format, this.partition);
            PositionDelete posDelete = PositionDelete.create();
            try (PositionDeleteWriter closeableWriter = writer;){
                posDeletes.forEach(posRow -> closeableWriter.write(posDelete.set(filePath.get(), posRow.pos(), posRow.row())));
            }
            catch (IOException e) {
                this.setFailure(e);
                throw new UncheckedIOException("Failed to write the sorted path/pos pairs to pos-delete file: " + outputFile.encryptingOutputFile().location(), e);
            }
            this.referencedDataFiles.addAll((Collection)writer.referencedDataFiles());
            this.completedFiles.add(writer.toDeleteFile());
        });
        this.posDeletes.clear();
    }

    private static class PosRow<R> {
        private final long pos;
        private final R row;

        static <R> PosRow<R> of(long pos, R row) {
            return new PosRow<R>(pos, row);
        }

        private PosRow(long pos, R row) {
            this.pos = pos;
            this.row = row;
        }

        long pos() {
            return this.pos;
        }

        R row() {
            return this.row;
        }
    }
}

