/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.transfer.s3.config.DownloadFilter;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.TransferDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class DownloadDirectoryRequest
implements TransferDirectoryRequest,
ToCopyableBuilder<Builder, DownloadDirectoryRequest> {
    private final Path destination;
    private final String bucket;
    private final DownloadFilter filter;
    private final Consumer<DownloadFileRequest.Builder> downloadFileRequestTransformer;
    private final Consumer<ListObjectsV2Request.Builder> listObjectsRequestTransformer;

    public DownloadDirectoryRequest(DefaultBuilder builder) {
        this.destination = (Path)Validate.paramNotNull((Object)builder.destination, (String)"destination");
        this.bucket = (String)Validate.paramNotNull((Object)builder.bucket, (String)"bucket");
        this.filter = builder.filter;
        this.downloadFileRequestTransformer = builder.downloadFileRequestTransformer;
        this.listObjectsRequestTransformer = builder.listObjectsRequestTransformer;
    }

    public Path destination() {
        return this.destination;
    }

    public String bucket() {
        return this.bucket;
    }

    public DownloadFilter filter() {
        return this.filter == null ? DownloadFilter.allObjects() : this.filter;
    }

    public Consumer<ListObjectsV2Request.Builder> listObjectsRequestTransformer() {
        return this.listObjectsRequestTransformer == null ? ignore -> {} : this.listObjectsRequestTransformer;
    }

    public Consumer<DownloadFileRequest.Builder> downloadFileRequestTransformer() {
        return this.downloadFileRequestTransformer == null ? ignore -> {} : this.downloadFileRequestTransformer;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadDirectoryRequest that = (DownloadDirectoryRequest)o;
        if (!Objects.equals(this.destination, that.destination)) {
            return false;
        }
        if (!Objects.equals(this.bucket, that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.downloadFileRequestTransformer, that.downloadFileRequestTransformer)) {
            return false;
        }
        if (!Objects.equals(this.listObjectsRequestTransformer, that.listObjectsRequestTransformer)) {
            return false;
        }
        return Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        int result = this.destination != null ? this.destination.hashCode() : 0;
        result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.downloadFileRequestTransformer != null ? this.downloadFileRequestTransformer.hashCode() : 0);
        result = 31 * result + (this.listObjectsRequestTransformer != null ? this.listObjectsRequestTransformer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DownloadDirectoryRequest").add("destination", (Object)this.destination).add("bucket", (Object)this.bucket).add("filter", (Object)this.filter).add("downloadFileRequestTransformer", this.downloadFileRequestTransformer).add("listObjectsRequestTransformer", this.listObjectsRequestTransformer).build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private Path destination;
        private String bucket;
        private DownloadFilter filter;
        private Consumer<DownloadFileRequest.Builder> downloadFileRequestTransformer;
        private Consumer<ListObjectsV2Request.Builder> listObjectsRequestTransformer;

        private DefaultBuilder() {
        }

        private DefaultBuilder(DownloadDirectoryRequest request) {
            this.destination = request.destination;
            this.bucket = request.bucket;
            this.filter = request.filter;
            this.downloadFileRequestTransformer = request.downloadFileRequestTransformer;
            this.listObjectsRequestTransformer = request.listObjectsRequestTransformer;
        }

        @Override
        public Builder destination(Path destination) {
            this.destination = destination;
            return this;
        }

        public void setDestination(Path destination) {
            this.destination(destination);
        }

        public Path getDestination() {
            return this.destination;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public void setBucket(String bucket) {
            this.bucket(bucket);
        }

        public String getBucket() {
            return this.bucket;
        }

        @Override
        public Builder filter(DownloadFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder downloadFileRequestTransformer(Consumer<DownloadFileRequest.Builder> downloadFileRequestTransformer) {
            this.downloadFileRequestTransformer = downloadFileRequestTransformer;
            return this;
        }

        @Override
        public Builder listObjectsV2RequestTransformer(Consumer<ListObjectsV2Request.Builder> listObjectsRequestTransformer) {
            this.listObjectsRequestTransformer = listObjectsRequestTransformer;
            return this;
        }

        public void setFilter(DownloadFilter filter) {
            this.filter(filter);
        }

        public DownloadFilter getFilter() {
            return this.filter;
        }

        public DownloadDirectoryRequest build() {
            return new DownloadDirectoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DownloadDirectoryRequest> {
        public Builder destination(Path var1);

        public Builder bucket(String var1);

        public Builder filter(DownloadFilter var1);

        public Builder downloadFileRequestTransformer(Consumer<DownloadFileRequest.Builder> var1);

        public Builder listObjectsV2RequestTransformer(Consumer<ListObjectsV2Request.Builder> var1);
    }
}

