/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.StartingEventBatchCondition;
import software.amazon.awssdk.services.glue.model.WorkflowGraph;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.services.glue.model.WorkflowRunStatistics;
import software.amazon.awssdk.services.glue.model.WorkflowRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowRun> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WorkflowRun.getter(WorkflowRun::name)).setter(WorkflowRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowRunId").getter(WorkflowRun.getter(WorkflowRun::workflowRunId)).setter(WorkflowRun.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowRunId").build()}).build();
    private static final SdkField<String> PREVIOUS_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousRunId").getter(WorkflowRun.getter(WorkflowRun::previousRunId)).setter(WorkflowRun.setter(Builder::previousRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousRunId").build()}).build();
    private static final SdkField<Map<String, String>> WORKFLOW_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("WorkflowRunProperties").getter(WorkflowRun.getter(WorkflowRun::workflowRunProperties)).setter(WorkflowRun.setter(Builder::workflowRunProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowRunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(WorkflowRun.getter(WorkflowRun::startedOn)).setter(WorkflowRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(WorkflowRun.getter(WorkflowRun::completedOn)).setter(WorkflowRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(WorkflowRun.getter(WorkflowRun::statusAsString)).setter(WorkflowRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(WorkflowRun.getter(WorkflowRun::errorMessage)).setter(WorkflowRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<WorkflowRunStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(WorkflowRun.getter(WorkflowRun::statistics)).setter(WorkflowRun.setter(Builder::statistics)).constructor(WorkflowRunStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final SdkField<WorkflowGraph> GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Graph").getter(WorkflowRun.getter(WorkflowRun::graph)).setter(WorkflowRun.setter(Builder::graph)).constructor(WorkflowGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Graph").build()}).build();
    private static final SdkField<StartingEventBatchCondition> STARTING_EVENT_BATCH_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartingEventBatchCondition").getter(WorkflowRun.getter(WorkflowRun::startingEventBatchCondition)).setter(WorkflowRun.setter(Builder::startingEventBatchCondition)).constructor(StartingEventBatchCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingEventBatchCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WORKFLOW_RUN_ID_FIELD, PREVIOUS_RUN_ID_FIELD, WORKFLOW_RUN_PROPERTIES_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, STATISTICS_FIELD, GRAPH_FIELD, STARTING_EVENT_BATCH_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String workflowRunId;
    private final String previousRunId;
    private final Map<String, String> workflowRunProperties;
    private final Instant startedOn;
    private final Instant completedOn;
    private final String status;
    private final String errorMessage;
    private final WorkflowRunStatistics statistics;
    private final WorkflowGraph graph;
    private final StartingEventBatchCondition startingEventBatchCondition;

    private WorkflowRun(BuilderImpl builder) {
        this.name = builder.name;
        this.workflowRunId = builder.workflowRunId;
        this.previousRunId = builder.previousRunId;
        this.workflowRunProperties = builder.workflowRunProperties;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.statistics = builder.statistics;
        this.graph = builder.graph;
        this.startingEventBatchCondition = builder.startingEventBatchCondition;
    }

    public final String name() {
        return this.name;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final String previousRunId() {
        return this.previousRunId;
    }

    public final boolean hasWorkflowRunProperties() {
        return this.workflowRunProperties != null && !(this.workflowRunProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> workflowRunProperties() {
        return this.workflowRunProperties;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final WorkflowRunStatus status() {
        return WorkflowRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final WorkflowRunStatistics statistics() {
        return this.statistics;
    }

    public final WorkflowGraph graph() {
        return this.graph;
    }

    public final StartingEventBatchCondition startingEventBatchCondition() {
        return this.startingEventBatchCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowRunProperties() ? this.workflowRunProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.graph());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingEventBatchCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRun)) {
            return false;
        }
        WorkflowRun other = (WorkflowRun)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.previousRunId(), other.previousRunId()) && this.hasWorkflowRunProperties() == other.hasWorkflowRunProperties() && Objects.equals(this.workflowRunProperties(), other.workflowRunProperties()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.graph(), other.graph()) && Objects.equals(this.startingEventBatchCondition(), other.startingEventBatchCondition());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowRun").add("Name", (Object)this.name()).add("WorkflowRunId", (Object)this.workflowRunId()).add("PreviousRunId", (Object)this.previousRunId()).add("WorkflowRunProperties", this.hasWorkflowRunProperties() ? this.workflowRunProperties() : null).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("Statistics", (Object)this.statistics()).add("Graph", (Object)this.graph()).add("StartingEventBatchCondition", (Object)this.startingEventBatchCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WorkflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "PreviousRunId": {
                return Optional.ofNullable(clazz.cast(this.previousRunId()));
            }
            case "WorkflowRunProperties": {
                return Optional.ofNullable(clazz.cast(this.workflowRunProperties()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "Graph": {
                return Optional.ofNullable(clazz.cast(this.graph()));
            }
            case "StartingEventBatchCondition": {
                return Optional.ofNullable(clazz.cast(this.startingEventBatchCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowRun, T> g) {
        return obj -> g.apply((WorkflowRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String workflowRunId;
        private String previousRunId;
        private Map<String, String> workflowRunProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant startedOn;
        private Instant completedOn;
        private String status;
        private String errorMessage;
        private WorkflowRunStatistics statistics;
        private WorkflowGraph graph;
        private StartingEventBatchCondition startingEventBatchCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowRun model) {
            this.name(model.name);
            this.workflowRunId(model.workflowRunId);
            this.previousRunId(model.previousRunId);
            this.workflowRunProperties(model.workflowRunProperties);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.statistics(model.statistics);
            this.graph(model.graph);
            this.startingEventBatchCondition(model.startingEventBatchCondition);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getPreviousRunId() {
            return this.previousRunId;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final Map<String, String> getWorkflowRunProperties() {
            if (this.workflowRunProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.workflowRunProperties;
        }

        public final void setWorkflowRunProperties(Map<String, String> workflowRunProperties) {
            this.workflowRunProperties = WorkflowRunPropertiesCopier.copy(workflowRunProperties);
        }

        @Override
        public final Builder workflowRunProperties(Map<String, String> workflowRunProperties) {
            this.workflowRunProperties = WorkflowRunPropertiesCopier.copy(workflowRunProperties);
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final WorkflowRunStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(WorkflowRunStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(WorkflowRunStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final WorkflowGraph.Builder getGraph() {
            return this.graph != null ? this.graph.toBuilder() : null;
        }

        public final void setGraph(WorkflowGraph.BuilderImpl graph) {
            this.graph = graph != null ? graph.build() : null;
        }

        @Override
        public final Builder graph(WorkflowGraph graph) {
            this.graph = graph;
            return this;
        }

        public final StartingEventBatchCondition.Builder getStartingEventBatchCondition() {
            return this.startingEventBatchCondition != null ? this.startingEventBatchCondition.toBuilder() : null;
        }

        public final void setStartingEventBatchCondition(StartingEventBatchCondition.BuilderImpl startingEventBatchCondition) {
            this.startingEventBatchCondition = startingEventBatchCondition != null ? startingEventBatchCondition.build() : null;
        }

        @Override
        public final Builder startingEventBatchCondition(StartingEventBatchCondition startingEventBatchCondition) {
            this.startingEventBatchCondition = startingEventBatchCondition;
            return this;
        }

        public WorkflowRun build() {
            return new WorkflowRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowRun> {
        public Builder name(String var1);

        public Builder workflowRunId(String var1);

        public Builder previousRunId(String var1);

        public Builder workflowRunProperties(Map<String, String> var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder status(String var1);

        public Builder status(WorkflowRunStatus var1);

        public Builder errorMessage(String var1);

        public Builder statistics(WorkflowRunStatistics var1);

        default public Builder statistics(Consumer<WorkflowRunStatistics.Builder> statistics) {
            return this.statistics((WorkflowRunStatistics)((WorkflowRunStatistics.Builder)WorkflowRunStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder graph(WorkflowGraph var1);

        default public Builder graph(Consumer<WorkflowGraph.Builder> graph) {
            return this.graph((WorkflowGraph)((WorkflowGraph.Builder)WorkflowGraph.builder().applyMutation(graph)).build());
        }

        public Builder startingEventBatchCondition(StartingEventBatchCondition var1);

        default public Builder startingEventBatchCondition(Consumer<StartingEventBatchCondition.Builder> startingEventBatchCondition) {
            return this.startingEventBatchCondition((StartingEventBatchCondition)((StartingEventBatchCondition.Builder)StartingEventBatchCondition.builder().applyMutation(startingEventBatchCondition)).build());
        }
    }
}

