/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityResultFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityResultFilterCriteria> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(DataQualityResultFilterCriteria.getter(DataQualityResultFilterCriteria::dataSource)).setter(DataQualityResultFilterCriteria.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(DataQualityResultFilterCriteria.getter(DataQualityResultFilterCriteria::jobName)).setter(DataQualityResultFilterCriteria.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunId").getter(DataQualityResultFilterCriteria.getter(DataQualityResultFilterCriteria::jobRunId)).setter(DataQualityResultFilterCriteria.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()}).build();
    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAfter").getter(DataQualityResultFilterCriteria.getter(DataQualityResultFilterCriteria::startedAfter)).setter(DataQualityResultFilterCriteria.setter(Builder::startedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAfter").build()}).build();
    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedBefore").getter(DataQualityResultFilterCriteria.getter(DataQualityResultFilterCriteria::startedBefore)).setter(DataQualityResultFilterCriteria.setter(Builder::startedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBefore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, JOB_NAME_FIELD, JOB_RUN_ID_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataSource dataSource;
    private final String jobName;
    private final String jobRunId;
    private final Instant startedAfter;
    private final Instant startedBefore;

    private DataQualityResultFilterCriteria(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public final Instant startedAfter() {
        return this.startedAfter;
    }

    public final Instant startedBefore() {
        return this.startedBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBefore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityResultFilterCriteria)) {
            return false;
        }
        DataQualityResultFilterCriteria other = (DataQualityResultFilterCriteria)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.startedAfter(), other.startedAfter()) && Objects.equals(this.startedBefore(), other.startedBefore());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityResultFilterCriteria").add("DataSource", (Object)this.dataSource()).add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).add("StartedAfter", (Object)this.startedAfter()).add("StartedBefore", (Object)this.startedBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "StartedAfter": {
                return Optional.ofNullable(clazz.cast(this.startedAfter()));
            }
            case "StartedBefore": {
                return Optional.ofNullable(clazz.cast(this.startedBefore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityResultFilterCriteria, T> g) {
        return obj -> g.apply((DataQualityResultFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSource dataSource;
        private String jobName;
        private String jobRunId;
        private Instant startedAfter;
        private Instant startedBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityResultFilterCriteria model) {
            this.dataSource(model.dataSource);
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
            this.startedAfter(model.startedAfter);
            this.startedBefore(model.startedBefore);
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Instant getStartedAfter() {
            return this.startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return this.startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public DataQualityResultFilterCriteria build() {
            return new DataQualityResultFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityResultFilterCriteria> {
        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder jobName(String var1);

        public Builder jobRunId(String var1);

        public Builder startedAfter(Instant var1);

        public Builder startedBefore(Instant var1);
    }
}

