/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encodable;

public final class StreamChunkId
implements Encodable {
    public final long streamId;
    public final int chunkIndex;

    public StreamChunkId(long streamId, int chunkIndex) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeLong(this.streamId);
        buffer.writeInt(this.chunkIndex);
    }

    public static StreamChunkId decode(ByteBuf buffer) {
        assert (buffer.readableBytes() >= 12);
        long streamId = buffer.readLong();
        int chunkIndex = buffer.readInt();
        return new StreamChunkId(streamId, chunkIndex);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.chunkIndex);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamChunkId) {
            StreamChunkId o = (StreamChunkId)other;
            return this.streamId == o.streamId && this.chunkIndex == o.chunkIndex;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("streamId", this.streamId).append("chunkIndex", this.chunkIndex).toString();
    }
}

