/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.util.List;
import java.util.Map;
import org.apache.amoro.server.catalog.CatalogType;
import org.apache.amoro.server.terminal.TerminalSessionFactory;

public interface TerminalSession {
    public Map<String, String> configs();

    public ResultSet executeStatement(String var1, String var2);

    public List<String> logs();

    public boolean active();

    public void release();

    public static boolean canUseSparkSessionCatalog(Map<String, String> sessionConf, String catalog) {
        String usingSessionCatalogForHiveKey = TerminalSessionFactory.SessionConfigOptions.USING_SESSION_CATALOG_FOR_HIVE.key();
        String usingSessionCatalogForHive = sessionConf.getOrDefault(usingSessionCatalogForHiveKey, "false");
        String type = sessionConf.get(TerminalSessionFactory.SessionConfigOptions.catalogProperty(catalog, "type").key());
        return usingSessionCatalogForHive.equals("true") && CatalogType.HIVE.name().equalsIgnoreCase(type);
    }

    public static interface ResultSet {
        public List<String> columns();

        public boolean next();

        public Object[] rowData();

        default public boolean empty() {
            List<String> columns = this.columns();
            return columns == null || columns.isEmpty();
        }

        public void close();
    }
}

