/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import java.time.Duration;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanFilesCleaningExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OrphanFilesCleaningExecutor.class);
    private final Duration interval;

    public OrphanFilesCleaningExecutor(TableService tableService, int poolSize, Duration interval) {
        super(tableService, poolSize);
        this.interval = interval;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return this.interval.toMillis();
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().isCleanOrphanEnabled();
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    public void execute(TableRuntime tableRuntime) {
        try {
            LOG.info("{} start cleaning orphan files", (Object)tableRuntime.getTableIdentifier());
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.cleanOrphanFiles(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("{} failed to clean orphan file", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }
}

