/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.converter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Map.class})
public class Map2StringConverter
implements TypeHandler<Map<String, String>> {
    private final Gson gson = new Gson();

    public void setParameter(PreparedStatement ps, int i, Map<String, String> parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setString(i, "");
        } else {
            ps.setString(i, this.gson.toJson(parameter));
        }
    }

    public Map<String, String> getResult(ResultSet rs, String columnName) throws SQLException {
        String res = rs.getString(columnName);
        if (res == null) {
            return null;
        }
        return (Map)this.gson.fromJson(res, new TypeToken<Map<String, String>>(){}.getType());
    }

    public Map<String, String> getResult(ResultSet rs, int columnIndex) throws SQLException {
        String res = rs.getString(columnIndex);
        if (res == null) {
            return null;
        }
        return (Map)this.gson.fromJson(res, new TypeToken<Map<String, String>>(){}.getType());
    }

    public Map<String, String> getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String res = cs.getString(columnIndex);
        if (res == null) {
            return null;
        }
        return (Map)this.gson.fromJson(res, new TypeToken<Map<String, String>>(){}.getType());
    }
}

