/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.amoro.ActivePlugin;
import org.apache.amoro.exception.AlreadyExistsException;
import org.apache.amoro.exception.LoadingPluginException;
import org.apache.amoro.server.Environments;
import org.apache.amoro.server.manager.ClassLoaderContext;
import org.apache.amoro.server.manager.PluginConfiguration;
import org.apache.amoro.server.manager.PluginManager;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.utils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractPluginManager<T extends ActivePlugin>
implements PluginManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPluginManager.class);
    private static final String PLUGIN_CONFIG_DIR_NAME = "plugins";
    private final Map<String, T> installedPlugins = new ConcurrentHashMap<String, T>();
    private final Map<String, T> foundedPlugins = new ConcurrentHashMap<String, T>();
    private final Map<String, PluginConfiguration> pluginConfigs = Maps.newConcurrentMap();
    private final String pluginCategory;
    private final Class<T> pluginType;

    public AbstractPluginManager(String pluginCategory) {
        this.pluginCategory = pluginCategory;
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (String)"%s isn't parameterized", (Object)superclass);
        this.pluginType = (Class)((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public void initialize() {
        List<PluginConfiguration> pluginConfigs = this.loadPluginConfigurations();
        pluginConfigs.forEach(config -> {
            PluginConfiguration exists = this.pluginConfigs.putIfAbsent(config.getName(), (PluginConfiguration)config);
            Preconditions.checkArgument((exists == null ? 1 : 0) != 0, (String)"Duplicate plugin name found: %s", (Object)config.getName());
        });
        this.foundAvailablePlugins();
        for (PluginConfiguration pluginConfig : pluginConfigs) {
            if (!pluginConfig.isEnabled()) continue;
            this.install(pluginConfig.getName());
        }
    }

    @Override
    public void install(String pluginName) {
        PluginConfiguration pluginConfig = this.pluginConfigs.get(pluginName);
        Preconditions.checkArgument((pluginConfig != null ? 1 : 0) != 0, (String)"Plugin configuration is not found for %s", (Object)pluginName);
        AtomicBoolean exists = new AtomicBoolean(true);
        this.installedPlugins.computeIfAbsent(pluginConfig.getName(), name -> {
            ActivePlugin plugin = (ActivePlugin)this.foundedPlugins.get(name);
            if (plugin == null) {
                throw new LoadingPluginException("Cannot find an implement class for the plugin:" + name);
            }
            plugin.open(pluginConfig.getProperties());
            exists.set(false);
            return plugin;
        });
        if (exists.get()) {
            throw new AlreadyExistsException("Plugin: " + pluginConfig.getName() + " has been already installed");
        }
    }

    @Override
    public void uninstall(String pluginName) {
        this.installedPlugins.computeIfPresent(pluginName, (name, plugin) -> {
            plugin.close();
            return null;
        });
    }

    @Override
    public T get(String pluginName) {
        return (T)((ActivePlugin)this.installedPlugins.get(pluginName));
    }

    @Override
    public void close() {
        this.forEach(plugin -> this.uninstall(plugin.name()));
    }

    @Override
    public List<T> installedPlugins() {
        return new ArrayList<T>(this.installedPlugins.values());
    }

    protected String pluginCategory() {
        return this.pluginCategory;
    }

    protected String pluginPath() {
        return Environments.getPluginPath() + "/" + this.pluginCategory();
    }

    protected Path pluginManagerConfigFilePath() {
        return Paths.get(Environments.getConfigPath(), PLUGIN_CONFIG_DIR_NAME, this.pluginCategory() + ".yaml");
    }

    protected void forEach(Consumer<? super T> visitor) {
        this.installedPlugins.values().forEach(plugin -> {
            try (ClassLoaderContext ignored = new ClassLoaderContext(plugin);){
                visitor.accept(plugin);
            }
            catch (Throwable throwable) {
                LOG.error("Error when call plugin: {}", (Object)plugin.name(), (Object)throwable);
            }
        });
    }

    private void foundAvailablePlugins() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader<T> buildInLoader = ServiceLoader.load(this.pluginType, classLoader);
        this.addToFoundedPlugin(buildInLoader);
        try {
            Path pluginPath = Paths.get(this.pluginPath(), new String[0]);
            if (!Files.exists(pluginPath, new LinkOption[0]) || !Files.isDirectory(pluginPath, new LinkOption[0])) {
                return;
            }
            Files.list(pluginPath).map(Path::toFile).forEach(file -> {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    this.findSingleJarExternalPlugins((File)file, classLoader);
                } else if (file.isDirectory()) {
                    this.findClasspathExternalPlugins((File)file, classLoader);
                }
            });
        }
        catch (IOException e) {
            throw new LoadingPluginException("Failed when discover available plugins", (Throwable)e);
        }
    }

    protected void findSingleJarExternalPlugins(File pluginJarFile, ClassLoader parentClassLoader) {
        try {
            URLClassLoader pluginClassLoader = new URLClassLoader(new URL[]{pluginJarFile.toURI().toURL()}, parentClassLoader);
            ServiceLoader<T> loader = ServiceLoader.load(this.pluginType, pluginClassLoader);
            this.addToFoundedPlugin(loader);
        }
        catch (MalformedURLException e) {
            throw new LoadingPluginException("Failed when load plugin", (Throwable)e);
        }
    }

    protected void findClasspathExternalPlugins(File pluginClasspath, ClassLoader parentClassLoader) {
        URL[] jarFiles = Optional.ofNullable(pluginClasspath.listFiles((dir, name) -> name.endsWith(".jar"))).map(Arrays::asList).map(files -> (URL[])files.stream().map(this::fileToURL).toArray(URL[]::new)).orElse(null);
        if (jarFiles != null) {
            URLClassLoader pluginClassLoader = new URLClassLoader(jarFiles, parentClassLoader);
            ServiceLoader<T> loader = ServiceLoader.load(this.pluginType, pluginClassLoader);
            this.addToFoundedPlugin(loader);
        }
    }

    @VisibleForTesting
    protected List<PluginConfiguration> loadPluginConfigurations() {
        JsonNode yamlConfig = null;
        Path mangerConfigPath = this.pluginManagerConfigFilePath();
        if (!Files.exists(mangerConfigPath, new LinkOption[0])) {
            return ImmutableList.of();
        }
        try {
            Object yamlObj = new Yaml().loadAs(Files.newInputStream(mangerConfigPath, new OpenOption[0]), Object.class);
            if (yamlObj instanceof Map) {
                yamlConfig = JacksonUtil.fromObjects((Object)yamlObj);
            }
        }
        catch (IOException e) {
            throw new LoadingPluginException("Failed when load plugin configs from file: " + mangerConfigPath, (Throwable)e);
        }
        LOG.info("initializing plugin configuration for: {}", (Object)this.pluginCategory());
        String pluginListKey = this.pluginCategory();
        JsonNode pluginConfigList = yamlConfig != null ? yamlConfig.get(pluginListKey) : null;
        ArrayList configs = Lists.newArrayList();
        if (pluginConfigList != null && !pluginConfigList.isEmpty()) {
            for (int i = 0; i < pluginConfigList.size(); ++i) {
                JsonNode pluginConfiguration = pluginConfigList.get(i);
                PluginConfiguration configuration = PluginConfiguration.fromJSONObject(pluginConfiguration);
                configs.add(configuration);
            }
        }
        return configs;
    }

    private URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addToFoundedPlugin(ServiceLoader<T> loader) {
        loader.forEach(plugin -> {
            ActivePlugin exists = this.foundedPlugins.putIfAbsent(plugin.name(), plugin);
            if (exists != null && !exists.getClass().equals(plugin.getClass())) {
                throw new IllegalStateException("Plugin name " + plugin.name() + " conflict, current plugin class: " + plugin.getClass().getName() + ", existing plugin class" + exists.getClass().getName());
            }
        });
    }
}

