/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.resource.ContainerMetadata;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.server.resource.ResourceContainers;
import org.glassfish.jersey.internal.guava.Sets;

public class SettingController {
    private static final String MASK_STRING = "******";
    private static final Set<String> MASK_CONFIGURATION_SET = Sets.newHashSet();
    private final OptimizerManager optimizerManager;
    private final Configurations serviceConfig;

    public SettingController(Configurations serviceConfig, OptimizerManager optimizerManager) {
        this.optimizerManager = optimizerManager;
        this.serviceConfig = serviceConfig;
    }

    public void getSystemSetting(Context ctx) {
        LinkedHashMap result = new LinkedHashMap();
        this.serviceConfig.toMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> this.putSetting(result, (String)entry.getKey(), entry.getValue()));
        ctx.json(OkResponse.of(result));
    }

    private void putSetting(Map<String, String> settingMap, String key, Object value) {
        if (MASK_CONFIGURATION_SET.contains(key)) {
            value = MASK_STRING;
        }
        settingMap.put(key, String.valueOf(value));
    }

    public void getContainerSetting(Context ctx) {
        List<ContainerMetadata> containerMetas = ResourceContainers.getMetadataList();
        ArrayList result = new ArrayList();
        Objects.requireNonNull(containerMetas).forEach(container -> {
            List optimizeGroups = this.optimizerManager.listResourceGroups(container.getName());
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("name", container.getName());
            obj.put("classpath", container.getImplClass());
            obj.put("properties", container.getProperties());
            obj.put("optimizeGroup", optimizeGroups);
            result.add(obj);
        });
        ctx.json(OkResponse.of(result));
    }

    static {
        MASK_CONFIGURATION_SET.add(AmoroManagementConf.DB_PASSWORD.key());
        MASK_CONFIGURATION_SET.add(AmoroManagementConf.ADMIN_PASSWORD.key());
    }
}

