/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.api.connector.sink2.CommittingSinkWriter;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSinkWriter;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.api.connector.sink2.SupportsWriterState;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.StandardSinkTopologies;
import org.apache.flink.streaming.api.connector.sink2.SupportsPostCommitTopology;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class SinkV1Adapter<InputT, CommT, WriterStateT, GlobalCommT>
implements org.apache.flink.api.connector.sink2.Sink<InputT> {
    private final Sink<InputT, CommT, WriterStateT, GlobalCommT> sink;

    private SinkV1Adapter(Sink<InputT, CommT, WriterStateT, GlobalCommT> sink) {
        this.sink = sink;
    }

    public static <InputT> org.apache.flink.api.connector.sink2.Sink<InputT> wrap(Sink<InputT, ?, ?, ?> sink) {
        return new SinkV1Adapter(sink).asSpecializedSink();
    }

    public SinkWriter<InputT> createWriter(Sink.InitContext context) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public SinkWriterV1Adapter<InputT, CommT, WriterStateT> createWriter(WriterInitContext context) throws IOException {
        org.apache.flink.api.connector.sink.SinkWriter writer = this.sink.createWriter((Sink.InitContext)new InitContextAdapter(context), Collections.emptyList());
        return new SinkWriterV1Adapter(writer);
    }

    public org.apache.flink.api.connector.sink2.Sink<InputT> asSpecializedSink() {
        boolean stateful = false;
        boolean globalCommitter = false;
        boolean committer = false;
        if (this.sink.getWriterStateSerializer().isPresent()) {
            stateful = true;
        }
        if (this.sink.getGlobalCommittableSerializer().isPresent()) {
            globalCommitter = true;
        }
        try {
            if (this.sink.createCommitter().isPresent()) {
                committer = true;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to instantiate committer.", e);
        }
        if (globalCommitter && committer && stateful) {
            return new StatefulGlobalTwoPhaseCommittingSinkAdapter();
        }
        if (globalCommitter) {
            return new GlobalCommittingSinkAdapter();
        }
        if (committer && stateful) {
            return new StatefulTwoPhaseCommittingSinkAdapter();
        }
        if (committer) {
            return new TwoPhaseCommittingSinkAdapter();
        }
        if (stateful) {
            return new StatefulSinkAdapter();
        }
        return this;
    }

    @Internal
    public class GlobalCommitterAdapter
    implements org.apache.flink.api.connector.sink2.Committer<CommT> {
        final GlobalCommitter<CommT, GlobalCommT> globalCommitter;
        final SimpleVersionedSerializer<GlobalCommT> globalCommittableSerializer;

        GlobalCommitterAdapter() {
            try {
                this.globalCommitter = (GlobalCommitter)SinkV1Adapter.this.sink.createGlobalCommitter().get();
                this.globalCommittableSerializer = (SimpleVersionedSerializer)SinkV1Adapter.this.sink.getGlobalCommittableSerializer().get();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot create global committer", e);
            }
        }

        public void close() throws Exception {
            this.globalCommitter.close();
        }

        public void commit(Collection<Committer.CommitRequest<CommT>> committables) throws IOException, InterruptedException {
            if (committables.isEmpty()) {
                return;
            }
            List rawCommittables = committables.stream().map(Committer.CommitRequest::getCommittable).collect(Collectors.toList());
            List<Object> globalCommittables = Collections.singletonList(this.globalCommitter.combine(rawCommittables));
            List failures = this.globalCommitter.commit(globalCommittables);
            if (!failures.isEmpty()) {
                committables.forEach(Committer.CommitRequest::retryLater);
            }
        }

        public GlobalCommitter<CommT, GlobalCommT> getGlobalCommitter() {
            return this.globalCommitter;
        }

        public SimpleVersionedSerializer<GlobalCommT> getGlobalCommittableSerializer() {
            return this.globalCommittableSerializer;
        }
    }

    private static class NoopCommitter<CommT>
    implements Committer<CommT> {
        private NoopCommitter() {
        }

        public List<CommT> commit(List<CommT> committables) {
            return Collections.emptyList();
        }

        public void close() throws Exception {
        }
    }

    private class StatefulGlobalTwoPhaseCommittingSinkAdapter
    extends StatefulTwoPhaseCommittingSinkAdapter
    implements SupportsPostCommitTopology<CommT> {
        GlobalCommittingSinkAdapter globalCommittingSinkAdapter;

        private StatefulGlobalTwoPhaseCommittingSinkAdapter() {
            this.globalCommittingSinkAdapter = new GlobalCommittingSinkAdapter();
        }

        @Override
        public void addPostCommitTopology(DataStream<CommittableMessage<CommT>> committables) {
            this.globalCommittingSinkAdapter.addPostCommitTopology(committables);
        }
    }

    private class StatefulTwoPhaseCommittingSinkAdapter
    extends StatefulSinkAdapter
    implements org.apache.flink.api.connector.sink2.Sink<InputT>,
    SupportsCommitter<CommT>,
    SupportsWriterState.WithCompatibleState {
        TwoPhaseCommittingSinkAdapter adapter;

        private StatefulTwoPhaseCommittingSinkAdapter() {
            this.adapter = new TwoPhaseCommittingSinkAdapter();
        }

        public org.apache.flink.api.connector.sink2.Committer<CommT> createCommitter(CommitterInitContext context) throws IOException {
            return this.adapter.createCommitter(context);
        }

        public SimpleVersionedSerializer<CommT> getCommittableSerializer() {
            return this.adapter.getCommittableSerializer();
        }

        public Collection<String> getCompatibleWriterStateNames() {
            return this.adapter.getCompatibleWriterStateNames();
        }
    }

    private class GlobalCommittingSinkAdapter
    extends TwoPhaseCommittingSinkAdapter
    implements SupportsPostCommitTopology<CommT> {
        private GlobalCommittingSinkAdapter() {
        }

        @Override
        public void addPostCommitTopology(DataStream<CommittableMessage<CommT>> committables) {
            StandardSinkTopologies.addGlobalCommitter(committables, (SerializableSupplier & Serializable)() -> new GlobalCommitterAdapter(), (SerializableSupplier & Serializable)() -> (SimpleVersionedSerializer)SinkV1Adapter.this.sink.getCommittableSerializer().get());
        }
    }

    private class TwoPhaseCommittingSinkAdapter
    extends PlainSinkAdapter
    implements SupportsCommitter<CommT>,
    SupportsWriterState.WithCompatibleState {
        private TwoPhaseCommittingSinkAdapter() {
        }

        public org.apache.flink.api.connector.sink2.Committer<CommT> createCommitter(CommitterInitContext context) throws IOException {
            return new CommitterAdapter(SinkV1Adapter.this.sink.createCommitter().orElse(new NoopCommitter()));
        }

        public SimpleVersionedSerializer<CommT> getCommittableSerializer() {
            return (SimpleVersionedSerializer)SinkV1Adapter.this.sink.getCommittableSerializer().orElseThrow(() -> new IllegalStateException("This method should only be called after adapter established that the result is non-empty."));
        }

        public Collection<String> getCompatibleWriterStateNames() {
            return SinkV1Adapter.this.sink.getCompatibleStateNames();
        }
    }

    private class StatefulSinkAdapter
    extends PlainSinkAdapter
    implements SupportsWriterState<InputT, WriterStateT> {
        private StatefulSinkAdapter() {
        }

        public StatefulSinkWriter<InputT, WriterStateT> restoreWriter(WriterInitContext context, Collection<WriterStateT> recoveredState) throws IOException {
            org.apache.flink.api.connector.sink.SinkWriter writer = SinkV1Adapter.this.sink.createWriter((Sink.InitContext)new InitContextAdapter(context), new ArrayList(recoveredState));
            return new SinkWriterV1Adapter(writer);
        }

        public SimpleVersionedSerializer<WriterStateT> getWriterStateSerializer() {
            return (SimpleVersionedSerializer)SinkV1Adapter.this.sink.getWriterStateSerializer().orElseThrow(() -> new IllegalStateException("This method should only be called after adapter established that the result is non-empty."));
        }
    }

    class PlainSinkAdapter
    implements org.apache.flink.api.connector.sink2.Sink<InputT> {
        PlainSinkAdapter() {
        }

        public SinkWriter<InputT> createWriter(Sink.InitContext context) throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public SinkWriterV1Adapter<InputT, CommT, WriterStateT> createWriter(WriterInitContext context) throws IOException {
            return SinkV1Adapter.this.createWriter(context);
        }

        public Sink<InputT, CommT, WriterStateT, GlobalCommT> getSink() {
            return SinkV1Adapter.this.sink;
        }
    }

    private static class CommitterAdapter<CommT>
    implements org.apache.flink.api.connector.sink2.Committer<CommT> {
        private final Committer<CommT> committer;

        public CommitterAdapter(Committer<CommT> committer) {
            this.committer = committer;
        }

        public void commit(Collection<Committer.CommitRequest<CommT>> commitRequests) throws IOException, InterruptedException {
            List failed = this.committer.commit(commitRequests.stream().map(Committer.CommitRequest::getCommittable).collect(Collectors.toList()));
            if (!failed.isEmpty()) {
                Set indexed = Collections.newSetFromMap(new IdentityHashMap());
                indexed.addAll(failed);
                commitRequests.stream().filter(request -> indexed.contains(request.getCommittable())).forEach(Committer.CommitRequest::retryLater);
            }
        }

        public void close() throws Exception {
            this.committer.close();
        }
    }

    private static class ProcessingTimeServiceAdapter
    implements Sink.ProcessingTimeService {
        private final ProcessingTimeService processingTimeService;

        public ProcessingTimeServiceAdapter(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        public long getCurrentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        public void registerProcessingTimer(long time, Sink.ProcessingTimeService.ProcessingTimeCallback processingTimerCallback) {
            this.processingTimeService.registerTimer(time, (ProcessingTimeService.ProcessingTimeCallback)new ProcessingTimeCallbackAdapter(processingTimerCallback));
        }
    }

    private static class ProcessingTimeCallbackAdapter
    implements ProcessingTimeService.ProcessingTimeCallback {
        private final Sink.ProcessingTimeService.ProcessingTimeCallback processingTimerCallback;

        public ProcessingTimeCallbackAdapter(Sink.ProcessingTimeService.ProcessingTimeCallback processingTimerCallback) {
            this.processingTimerCallback = processingTimerCallback;
        }

        public void onProcessingTime(long time) throws IOException, InterruptedException {
            this.processingTimerCallback.onProcessingTime(time);
        }
    }

    private static class InitContextAdapter
    implements Sink.InitContext {
        private final WriterInitContext context;

        public InitContextAdapter(WriterInitContext context) {
            this.context = context;
        }

        public UserCodeClassLoader getUserCodeClassLoader() {
            return this.context.getUserCodeClassLoader();
        }

        public MailboxExecutor getMailboxExecutor() {
            return this.context.getMailboxExecutor();
        }

        public Sink.ProcessingTimeService getProcessingTimeService() {
            return new ProcessingTimeServiceAdapter(this.context.getProcessingTimeService());
        }

        public int getSubtaskId() {
            return this.context.getTaskInfo().getIndexOfThisSubtask();
        }

        public int getNumberOfParallelSubtasks() {
            return this.context.getTaskInfo().getNumberOfParallelSubtasks();
        }

        public SinkWriterMetricGroup metricGroup() {
            return this.context.metricGroup();
        }

        public OptionalLong getRestoredCheckpointId() {
            return this.context.getRestoredCheckpointId();
        }

        public SerializationSchema.InitializationContext asSerializationSchemaInitializationContext() {
            return this.context.asSerializationSchemaInitializationContext();
        }
    }

    private static class WriterContextAdapter
    implements SinkWriter.Context {
        private SinkWriter.Context context;

        private WriterContextAdapter() {
        }

        public void setContext(SinkWriter.Context context) {
            this.context = context;
        }

        public long currentWatermark() {
            return this.context.currentWatermark();
        }

        public Long timestamp() {
            return this.context.timestamp();
        }
    }

    private static class SinkWriterV1Adapter<InputT, CommT, WriterStateT>
    implements StatefulSinkWriter<InputT, WriterStateT>,
    CommittingSinkWriter<InputT, CommT> {
        private final org.apache.flink.api.connector.sink.SinkWriter<InputT, CommT, WriterStateT> writer;
        private boolean endOfInput = false;
        private final WriterContextAdapter contextAdapter = new WriterContextAdapter();

        public SinkWriterV1Adapter(org.apache.flink.api.connector.sink.SinkWriter<InputT, CommT, WriterStateT> writer) {
            this.writer = writer;
        }

        public void write(InputT element, SinkWriter.Context context) throws IOException, InterruptedException {
            this.contextAdapter.setContext(context);
            this.writer.write(element, (SinkWriter.Context)this.contextAdapter);
        }

        public void flush(boolean endOfInput) throws IOException, InterruptedException {
            this.endOfInput = endOfInput;
        }

        public List<WriterStateT> snapshotState(long checkpointId) throws IOException {
            return this.writer.snapshotState(checkpointId);
        }

        public Collection<CommT> prepareCommit() throws IOException, InterruptedException {
            return this.writer.prepareCommit(this.endOfInput);
        }

        public void close() throws Exception {
            this.writer.close();
        }

        public void writeWatermark(Watermark watermark) throws IOException, InterruptedException {
            this.writer.writeWatermark(watermark);
        }
    }
}

