/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.common;

public class DatabaseName {
    static final String CAT_DB_TABLE_SEPARATOR = ".";
    private final String cat;
    private final String db;

    public DatabaseName(String cat, String db) {
        this.cat = cat;
        this.db = db;
    }

    public static DatabaseName fromString(String name, String defaultCatalog) {
        if (name.contains(CAT_DB_TABLE_SEPARATOR)) {
            String[] names = name.split("\\.");
            if (names.length != 2) {
                throw new RuntimeException("Database name must be either <dbname> or <catname>.<dbname>");
            }
            return new DatabaseName(names[0], names[1]);
        }
        assert (defaultCatalog != null);
        return new DatabaseName(defaultCatalog, name);
    }

    public String getCat() {
        return this.cat;
    }

    public String getDb() {
        return this.db;
    }

    public static String getQualified(String catName, String dbName) {
        return catName + CAT_DB_TABLE_SEPARATOR + dbName;
    }

    public int hashCode() {
        return this.cat.hashCode() * 31 + this.db.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DatabaseName) {
            DatabaseName that = (DatabaseName)obj;
            return this.db.equals(that.db) && this.cat.equals(that.cat);
        }
        return false;
    }

    public String toString() {
        return this.cat + CAT_DB_TABLE_SEPARATOR + this.db;
    }
}

