/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.aggr.BinaryColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.BooleanColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DateColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DecimalColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DoubleColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.LongColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.StringColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;

public class ColumnStatsAggregatorFactory {
    private ColumnStatsAggregatorFactory() {
    }

    public static ColumnStatsAggregator getColumnStatsAggregator(ColumnStatisticsData._Fields type, boolean useDensityFunctionForNDVEstimation, double ndvTuner) {
        ColumnStatsAggregator agg;
        switch (type) {
            case BOOLEAN_STATS: {
                agg = new BooleanColumnStatsAggregator();
                break;
            }
            case LONG_STATS: {
                agg = new LongColumnStatsAggregator();
                break;
            }
            case DATE_STATS: {
                agg = new DateColumnStatsAggregator();
                break;
            }
            case DOUBLE_STATS: {
                agg = new DoubleColumnStatsAggregator();
                break;
            }
            case STRING_STATS: {
                agg = new StringColumnStatsAggregator();
                break;
            }
            case BINARY_STATS: {
                agg = new BinaryColumnStatsAggregator();
                break;
            }
            case DECIMAL_STATS: {
                agg = new DecimalColumnStatsAggregator();
                break;
            }
            default: {
                throw new RuntimeException("Woh, bad.  Unknown stats type " + type.toString());
            }
        }
        agg.useDensityFunctionForNDVEstimation = useDensityFunctionForNDVEstimation;
        agg.ndvTuner = ndvTuner;
        return agg;
    }

    public static ColumnStatisticsObj newColumnStaticsObj(String colName, String colType, ColumnStatisticsData._Fields type) {
        ColumnStatisticsObj cso = new ColumnStatisticsObj();
        ColumnStatisticsData csd = new ColumnStatisticsData();
        cso.setColName(colName);
        cso.setColType(colType);
        switch (type) {
            case BOOLEAN_STATS: {
                csd.setBooleanStats(new BooleanColumnStatsData());
                break;
            }
            case LONG_STATS: {
                csd.setLongStats(new LongColumnStatsDataInspector());
                break;
            }
            case DATE_STATS: {
                csd.setDateStats(new DateColumnStatsDataInspector());
                break;
            }
            case DOUBLE_STATS: {
                csd.setDoubleStats(new DoubleColumnStatsDataInspector());
                break;
            }
            case STRING_STATS: {
                csd.setStringStats(new StringColumnStatsDataInspector());
                break;
            }
            case BINARY_STATS: {
                csd.setBinaryStats(new BinaryColumnStatsData());
                break;
            }
            case DECIMAL_STATS: {
                csd.setDecimalStats(new DecimalColumnStatsDataInspector());
                break;
            }
            default: {
                throw new RuntimeException("Woh, bad.  Unknown stats type!");
            }
        }
        cso.setStatsData(csd);
        return cso;
    }
}

