/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.SessionCatalogBase;
import org.apache.amoro.spark.SparkTableFormat;
import org.apache.amoro.spark.SparkUnifiedCatalogBase;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureCatalog;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public abstract class SparkUnifiedSessionCatalogBase<T extends TableCatalog & SupportsNamespaces>
extends SessionCatalogBase<T>
implements ProcedureCatalog {
    protected final Map<TableFormat, SparkTableFormat> tableFormats = Maps.newConcurrentMap();

    protected abstract SparkUnifiedCatalogBase createUnifiedCatalog(String var1, CaseInsensitiveStringMap var2);

    @Override
    protected TableCatalog buildTargetCatalog(String name, CaseInsensitiveStringMap options) {
        SparkUnifiedCatalogBase sparkUnifiedCatalog = this.createUnifiedCatalog(name, options);
        sparkUnifiedCatalog.initialize(name, options);
        ServiceLoader<SparkTableFormat> sparkTableFormats = ServiceLoader.load(SparkTableFormat.class);
        for (SparkTableFormat format : sparkTableFormats) {
            this.tableFormats.put(format.format(), format);
        }
        return sparkUnifiedCatalog;
    }

    @Override
    protected boolean isManagedTable(Table table) {
        return this.tableFormats.values().stream().anyMatch(f -> f.isFormatOf(table));
    }

    @Override
    protected boolean isManagedProvider(String provider) {
        if (provider == null) {
            return false;
        }
        try {
            TableFormat.valueOf((String)provider.toUpperCase());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected boolean isManagedSubTable(Identifier ident) {
        if (ident.namespace().length == 2) {
            for (SparkTableFormat sparkTableFormat : this.tableFormats.values()) {
                if (!sparkTableFormat.isSubTableName(ident.name())) continue;
                return true;
            }
        }
        return false;
    }

    public Procedure loadProcedure(Identifier ident) throws NoSuchProcedureException {
        SparkUnifiedCatalogBase catalog = (SparkUnifiedCatalogBase)this.getTargetCatalog();
        return catalog.loadProcedure(ident);
    }
}

