/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.clock;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.clock.Clock;

@PublicEvolving
public final class ManualClock
extends Clock {
    private final AtomicLong currentTime;

    public ManualClock() {
        this(0L);
    }

    public ManualClock(long startTime) {
        this.currentTime = new AtomicLong(startTime);
    }

    @Override
    public long absoluteTimeMillis() {
        return this.currentTime.get() / 1000000L;
    }

    @Override
    public long relativeTimeMillis() {
        return this.currentTime.get() / 1000000L;
    }

    @Override
    public long relativeTimeNanos() {
        return this.currentTime.get();
    }

    public void advanceTime(long duration, TimeUnit timeUnit) {
        this.currentTime.addAndGet(timeUnit.toNanos(duration));
    }

    public void advanceTime(Duration duration) {
        this.currentTime.addAndGet(duration.toNanos());
    }
}

