/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.util.MdcAwareExecutor;
import org.apache.flink.util.MdcAwareExecutorService;
import org.apache.flink.util.MdcAwareScheduledExecutorService;
import org.apache.flink.util.Preconditions;
import org.slf4j.MDC;

public class MdcUtils {
    public static final String JOB_ID = "flink-job-id";

    public static MdcCloseable withContext(Map<String, String> context) {
        Map orig = MDC.getCopyOfContextMap();
        MDC.setContextMap(context);
        return () -> MDC.setContextMap((Map)orig);
    }

    public static Runnable wrapRunnable(Map<String, String> contextData, Runnable command) {
        return () -> {
            try (MdcCloseable ctx = MdcUtils.withContext(contextData);){
                command.run();
            }
        };
    }

    public static <T> Callable<T> wrapCallable(Map<String, String> contextData, Callable<T> command) {
        return () -> {
            try (MdcCloseable ctx = MdcUtils.withContext(contextData);){
                Object v = command.call();
                return v;
            }
        };
    }

    public static Executor scopeToJob(JobID jobID, Executor executor) {
        Preconditions.checkArgument(!(executor instanceof MdcAwareExecutor));
        return new MdcAwareExecutor<Executor>(executor, MdcUtils.asContextData(jobID));
    }

    public static ExecutorService scopeToJob(JobID jobID, ExecutorService delegate) {
        Preconditions.checkArgument(!(delegate instanceof MdcAwareExecutorService));
        return new MdcAwareExecutorService<ExecutorService>(delegate, MdcUtils.asContextData(jobID));
    }

    public static ScheduledExecutorService scopeToJob(JobID jobID, ScheduledExecutorService ses) {
        Preconditions.checkArgument(!(ses instanceof MdcAwareScheduledExecutorService));
        return new MdcAwareScheduledExecutorService(ses, MdcUtils.asContextData(jobID));
    }

    public static Map<String, String> asContextData(JobID jobID) {
        return Collections.singletonMap(JOB_ID, jobID.toHexString());
    }

    public static interface MdcCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

