/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public class CompositeTypeSerializerUtil {
    public static <T> TypeSerializerSchemaCompatibility<T> delegateCompatibilityCheckToNewSnapshot(TypeSerializerSnapshot<T> legacySerializerSnapshot, CompositeTypeSerializerSnapshot<T, ? extends TypeSerializer<T>> newCompositeSnapshot, TypeSerializerSnapshot<?> ... legacyNestedSnapshots) {
        Preconditions.checkArgument(legacyNestedSnapshots.length > 0);
        return newCompositeSnapshot.internalResolveSchemaCompatibility(legacySerializerSnapshot, legacyNestedSnapshots);
    }

    public static void setNestedSerializersSnapshots(CompositeTypeSerializerSnapshot<?, ?> compositeSnapshot, TypeSerializerSnapshot<?> ... nestedSnapshots) {
        NestedSerializersSnapshotDelegate delegate = new NestedSerializersSnapshotDelegate(nestedSnapshots);
        compositeSnapshot.setNestedSerializersSnapshotDelegate(delegate);
    }

    public static <T> IntermediateCompatibilityResult<T> constructIntermediateCompatibilityResult(TypeSerializerSnapshot<?>[] newNestedSerializerSnapshots, TypeSerializerSnapshot<?>[] oldNestedSerializerSnapshots) {
        Preconditions.checkArgument(newNestedSerializerSnapshots.length == oldNestedSerializerSnapshots.length, "Different number of new serializer snapshots and existing serializer snapshots.");
        TypeSerializer[] nestedSerializers = new TypeSerializer[newNestedSerializerSnapshots.length];
        boolean nestedSerializerRequiresMigration = false;
        boolean hasReconfiguredNestedSerializers = false;
        for (int i = 0; i < oldNestedSerializerSnapshots.length; ++i) {
            TypeSerializerSchemaCompatibility compatibility = CompositeTypeSerializerUtil.resolveCompatibility(newNestedSerializerSnapshots[i], oldNestedSerializerSnapshots[i]);
            if (compatibility.isIncompatible()) {
                return IntermediateCompatibilityResult.definedIncompatibleResult();
            }
            if (compatibility.isCompatibleAfterMigration()) {
                nestedSerializerRequiresMigration = true;
                continue;
            }
            if (compatibility.isCompatibleWithReconfiguredSerializer()) {
                hasReconfiguredNestedSerializers = true;
                nestedSerializers[i] = compatibility.getReconfiguredSerializer();
                continue;
            }
            if (compatibility.isCompatibleAsIs()) {
                nestedSerializers[i] = newNestedSerializerSnapshots[i].restoreSerializer();
                continue;
            }
            throw new IllegalStateException("Undefined compatibility type.");
        }
        if (nestedSerializerRequiresMigration) {
            return IntermediateCompatibilityResult.definedCompatibleAfterMigrationResult();
        }
        if (hasReconfiguredNestedSerializers) {
            return IntermediateCompatibilityResult.undefinedReconfigureResult(nestedSerializers);
        }
        return IntermediateCompatibilityResult.definedCompatibleAsIsResult(nestedSerializers);
    }

    private static <E> TypeSerializerSchemaCompatibility<E> resolveCompatibility(TypeSerializerSnapshot<?> newSnapshot, TypeSerializerSnapshot<?> oldSnapshot) {
        TypeSerializerSnapshot<?> typedNewSnapshot = newSnapshot;
        TypeSerializerSnapshot<?> typedOldSnapshot = oldSnapshot;
        return typedNewSnapshot.resolveSchemaCompatibility(typedOldSnapshot);
    }

    public static class IntermediateCompatibilityResult<T> {
        private final TypeSerializerSchemaCompatibility.Type compatibilityType;
        private final TypeSerializer<?>[] nestedSerializers;

        static <T> IntermediateCompatibilityResult<T> definedCompatibleAsIsResult(TypeSerializer<?>[] originalSerializers) {
            return new IntermediateCompatibilityResult<T>(TypeSerializerSchemaCompatibility.Type.COMPATIBLE_AS_IS, originalSerializers);
        }

        static <T> IntermediateCompatibilityResult<T> definedIncompatibleResult() {
            return new IntermediateCompatibilityResult<T>(TypeSerializerSchemaCompatibility.Type.INCOMPATIBLE, null);
        }

        static <T> IntermediateCompatibilityResult<T> definedCompatibleAfterMigrationResult() {
            return new IntermediateCompatibilityResult<T>(TypeSerializerSchemaCompatibility.Type.COMPATIBLE_AFTER_MIGRATION, null);
        }

        static <T> IntermediateCompatibilityResult<T> undefinedReconfigureResult(TypeSerializer<?>[] reconfiguredNestedSerializers) {
            return new IntermediateCompatibilityResult<T>(TypeSerializerSchemaCompatibility.Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER, reconfiguredNestedSerializers);
        }

        private IntermediateCompatibilityResult(TypeSerializerSchemaCompatibility.Type compatibilityType, TypeSerializer<?>[] nestedSerializers) {
            this.compatibilityType = Preconditions.checkNotNull(compatibilityType);
            this.nestedSerializers = nestedSerializers;
        }

        public boolean isCompatibleWithReconfiguredSerializer() {
            return this.compatibilityType == TypeSerializerSchemaCompatibility.Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER;
        }

        public boolean isCompatibleAsIs() {
            return this.compatibilityType == TypeSerializerSchemaCompatibility.Type.COMPATIBLE_AS_IS;
        }

        public boolean isCompatibleAfterMigration() {
            return this.compatibilityType == TypeSerializerSchemaCompatibility.Type.COMPATIBLE_AFTER_MIGRATION;
        }

        public boolean isIncompatible() {
            return this.compatibilityType == TypeSerializerSchemaCompatibility.Type.INCOMPATIBLE;
        }

        public TypeSerializerSchemaCompatibility<T> getFinalResult() {
            Preconditions.checkState(this.compatibilityType != TypeSerializerSchemaCompatibility.Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER, "unable to build final result if intermediate compatibility type is COMPATIBLE_WITH_RECONFIGURED_SERIALIZER.");
            switch (this.compatibilityType) {
                case COMPATIBLE_AS_IS: {
                    return TypeSerializerSchemaCompatibility.compatibleAsIs();
                }
                case COMPATIBLE_AFTER_MIGRATION: {
                    return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
                }
                case INCOMPATIBLE: {
                    return TypeSerializerSchemaCompatibility.incompatible();
                }
            }
            throw new IllegalStateException("unrecognized compatibility type.");
        }

        public TypeSerializer<?>[] getNestedSerializers() {
            Preconditions.checkState(this.compatibilityType == TypeSerializerSchemaCompatibility.Type.COMPATIBLE_AS_IS || this.compatibilityType == TypeSerializerSchemaCompatibility.Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER, "only intermediate compatibility types COMPATIBLE_AS_IS and COMPATIBLE_WITH_RECONFIGURED_SERIALIZER have nested serializers.");
            return this.nestedSerializers;
        }
    }
}

