/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.streaming.api.functions.sink.filesystem.CompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowWisePartWriter<IN, BucketID>
extends OutputStreamBasedPartFileWriter<IN, BucketID> {
    private final Encoder<IN> encoder;

    public RowWisePartWriter(BucketID bucketId, Path path, RecoverableFsDataOutputStream currentPartStream, Encoder<IN> encoder, long creationTime) {
        super(bucketId, path, currentPartStream, creationTime);
        this.encoder = (Encoder)Preconditions.checkNotNull(encoder);
    }

    @Override
    public void write(IN element, long currentTime) throws IOException {
        this.ensureWriteType(CompactingFileWriter.Type.RECORD_WISE);
        this.encoder.encode(element, (OutputStream)this.currentPartStream);
        this.markWrite(currentTime);
    }
}

