/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.expressions.Term;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParserInterface;

public interface ExtendedParser
extends ParserInterface {
    public static List<RawOrderField> parseSortOrder(SparkSession spark, String orderString) {
        if (spark.sessionState().sqlParser() instanceof ExtendedParser) {
            ExtendedParser parser = (ExtendedParser)spark.sessionState().sqlParser();
            try {
                return parser.parseSortOrder(orderString);
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException(String.format("Unable to parse sortOrder: %s", orderString), e);
            }
        }
        throw new IllegalStateException("Cannot parse order: parser is not an Iceberg ExtendedParser");
    }

    public List<RawOrderField> parseSortOrder(String var1) throws AnalysisException;

    public static class RawOrderField {
        private final Term term;
        private final SortDirection direction;
        private final NullOrder nullOrder;

        public RawOrderField(Term term, SortDirection direction, NullOrder nullOrder) {
            this.term = term;
            this.direction = direction;
            this.nullOrder = nullOrder;
        }

        public Term term() {
            return this.term;
        }

        public SortDirection direction() {
            return this.direction;
        }

        public NullOrder nullOrder() {
            return this.nullOrder;
        }
    }
}

