/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignRequest;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignResponse;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.apache.iceberg.aws.s3.signer.S3SignRequestParser;
import org.apache.iceberg.aws.s3.signer.S3SignResponse;
import org.apache.iceberg.aws.s3.signer.S3SignResponseParser;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;

public class S3ObjectMapper {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static volatile boolean isInitialized = false;

    private S3ObjectMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ObjectMapper mapper() {
        if (isInitialized) return MAPPER;
        Class<S3ObjectMapper> clazz = S3ObjectMapper.class;
        synchronized (S3ObjectMapper.class) {
            if (isInitialized) return MAPPER;
            MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MAPPER.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());
            MAPPER.registerModule((Module)S3ObjectMapper.initModule());
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return MAPPER;
        }
    }

    public static SimpleModule initModule() {
        return new SimpleModule().addSerializer(ErrorResponse.class, (JsonSerializer)new RESTSerializers.ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, (JsonDeserializer)new RESTSerializers.ErrorResponseDeserializer()).addSerializer(OAuthTokenResponse.class, (JsonSerializer)new RESTSerializers.OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, (JsonDeserializer)new RESTSerializers.OAuthTokenResponseDeserializer()).addSerializer(S3SignRequest.class, new S3SignRequestSerializer()).addSerializer(ImmutableS3SignRequest.class, new S3SignRequestSerializer()).addDeserializer(S3SignRequest.class, new S3SignRequestDeserializer()).addDeserializer(ImmutableS3SignRequest.class, new S3SignRequestDeserializer()).addSerializer(S3SignResponse.class, new S3SignResponseSerializer()).addSerializer(ImmutableS3SignResponse.class, new S3SignResponseSerializer()).addDeserializer(S3SignResponse.class, new S3SignResponseDeserializer()).addDeserializer(ImmutableS3SignResponse.class, new S3SignResponseDeserializer());
    }

    public static class S3SignResponseDeserializer<T extends S3SignResponse>
    extends JsonDeserializer<T> {
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)S3SignResponseParser.fromJson(jsonNode);
        }
    }

    public static class S3SignResponseSerializer<T extends S3SignResponse>
    extends JsonSerializer<T> {
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            S3SignResponseParser.toJson(request, gen);
        }
    }

    public static class S3SignRequestDeserializer<T extends S3SignRequest>
    extends JsonDeserializer<T> {
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)S3SignRequestParser.fromJson(jsonNode);
        }
    }

    public static class S3SignRequestSerializer<T extends S3SignRequest>
    extends JsonSerializer<T> {
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            S3SignRequestParser.toJson(request, gen);
        }
    }
}

