/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo.utils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.flink.annotation.Experimental;

@Experimental
public class TypeUtils
implements Serializable {
    public static Object getInstance(String classPath, Object ... args) throws ReflectiveOperationException {
        Constructor<?>[] constructors;
        Class<?> descriptorClass = Class.forName(classPath);
        for (Constructor<?> constructor : constructors = descriptorClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (!TypeUtils.areParameterTypesCompatible(parameterTypes, args)) continue;
            return constructor.newInstance(TypeUtils.convertArgs(parameterTypes, args));
        }
        throw new NoSuchMethodException("No suitable constructor found for the given arguments.");
    }

    private static boolean areParameterTypesCompatible(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!(args[i] == null ? parameterTypes[i].isPrimitive() : !TypeUtils.isCompatible(parameterTypes[i], args[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompatible(Class<?> parameterType, Object arg) {
        if (parameterType.isPrimitive()) {
            Class<?> wrapperType = TypeUtils.getWrapperClass(parameterType);
            return wrapperType.isInstance(arg);
        }
        return parameterType.isInstance(arg);
    }

    private static Class<?> getWrapperClass(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Unknown primitive type: " + primitiveType.getName());
    }

    private static Object[] convertArgs(Class<?>[] parameterTypes, Object[] args) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            convertedArgs[i] = parameterTypes[i].isPrimitive() ? TypeUtils.convertToPrimitiveWrapper(parameterTypes[i], args[i]) : args[i];
        }
        return convertedArgs;
    }

    private static Object convertToPrimitiveWrapper(Class<?> parameterType, Object arg) {
        if (parameterType == Boolean.TYPE) {
            return (Boolean)arg;
        }
        if (parameterType == Byte.TYPE) {
            return (Byte)arg;
        }
        if (parameterType == Character.TYPE) {
            return (Character)arg;
        }
        if (parameterType == Short.TYPE) {
            return (Short)arg;
        }
        if (parameterType == Integer.TYPE) {
            return (Integer)arg;
        }
        if (parameterType == Long.TYPE) {
            return (Long)arg;
        }
        if (parameterType == Float.TYPE) {
            return (Float)arg;
        }
        if (parameterType == Double.TYPE) {
            return (Double)arg;
        }
        throw new IllegalArgumentException("Unknown primitive type: " + parameterType.getName());
    }
}

