/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.amoro.client.AmsServerInfo;
import org.apache.amoro.client.ZookeeperService;
import org.apache.amoro.properties.AmsHAProperties;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.amoro.utils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmsThriftUrl {
    public static final String PARAM_SOCKET_TIMEOUT = "socketTimeout";
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static final String ZOOKEEPER_FLAG = "zookeeper";
    public static final String THRIFT_FLAG = "thrift";
    public static final String THRIFT_URL_FORMAT = "thrift://%s:%d/%s%s";
    public static final int MAX_RETRIES = 3;
    private static final Logger logger = LoggerFactory.getLogger(AmsThriftUrl.class);
    private static final Pattern PATTERN = Pattern.compile("zookeeper://(\\S+)/([\\w-]+)");
    private final String schema;
    private final String host;
    private final int port;
    private final String catalogName;
    private final int socketTimeout;
    private final String url;

    private AmsThriftUrl(String schema, String host, int port, String catalogName, int socketTimeout, String url) {
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.catalogName = catalogName;
        this.socketTimeout = socketTimeout;
        this.url = url;
    }

    public static AmsThriftUrl parse(String url, String serviceName) {
        if (url == null) {
            throw new IllegalArgumentException("thrift url is null");
        }
        if (url.startsWith(ZOOKEEPER_FLAG)) {
            return AmsThriftUrl.parserZookeeperUrl(url, serviceName);
        }
        return AmsThriftUrl.parserThriftUrl(url);
    }

    private static AmsThriftUrl parserThriftUrl(String url) {
        int socketTimeout = 5000;
        try {
            URI uri = new URI(url.toLowerCase(Locale.ROOT));
            String schema = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (uri.getQuery() != null) {
                for (String paramExpression : uri.getQuery().split("&")) {
                    String[] paramSplit = paramExpression.split("=");
                    if (paramSplit.length != 2 || !paramSplit[0].equalsIgnoreCase(PARAM_SOCKET_TIMEOUT)) continue;
                    socketTimeout = Integer.parseInt(paramSplit[1]);
                }
            }
            String catalogName = path;
            return new AmsThriftUrl(schema, host, port, catalogName, socketTimeout, url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("parse metastore url failed", e);
        }
    }

    private static AmsThriftUrl parserZookeeperUrl(String url, String serviceName) {
        Matcher m;
        String thriftUrl = url;
        String query = "";
        if (url.contains("?")) {
            query = url.substring(url.indexOf("?"));
            thriftUrl = url.substring(0, url.indexOf("?"));
        }
        if ((m = PATTERN.matcher(thriftUrl)).matches()) {
            String cluster;
            String zkServerAddress;
            String catalog = "";
            if (m.group(1).contains("/")) {
                zkServerAddress = m.group(1).substring(0, m.group(1).indexOf("/"));
                cluster = m.group(1).substring(m.group(1).indexOf("/") + 1);
                catalog = m.group(2);
            } else {
                zkServerAddress = m.group(1);
                cluster = m.group(2);
            }
            int retryCount = 0;
            while (retryCount < 3) {
                try {
                    AmsServerInfo serverInfo = AmsThriftUrl.findAmsServerInfo(serviceName, zkServerAddress, cluster);
                    url = String.format(THRIFT_URL_FORMAT, serverInfo.getHost(), serverInfo.getThriftBindPort(), catalog, query);
                    int socketTimeout = 5000;
                    for (String paramExpression : query.replace("?", "").split("&")) {
                        String[] paramSplit = paramExpression.split("=");
                        if (paramSplit.length != 2 || !paramSplit[0].equalsIgnoreCase(PARAM_SOCKET_TIMEOUT)) continue;
                        socketTimeout = Integer.parseInt(paramSplit[1]);
                    }
                    return new AmsThriftUrl(THRIFT_FLAG, serverInfo.getHost(), serverInfo.getThriftBindPort(), catalog.toLowerCase(), socketTimeout, url);
                }
                catch (KeeperException.AuthFailedException authFailedException) {
                    logger.error(String.format("Caught exception, retrying... (retry count: %s)", ++retryCount), (Throwable)authFailedException);
                    try {
                        Subject subject = Subject.getSubject(AccessController.getContext());
                        if (subject == null) continue;
                        LoginContext loginContext = new LoginContext("", subject);
                        loginContext.logout();
                    }
                    catch (LoginException e) {
                        logger.error("Failed to logout", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("Caught exception, retrying... (retry count: %s)", ++retryCount), (Throwable)e);
                    throw new RuntimeException(String.format("invalid ams url %s", url));
                }
            }
        } else {
            throw new RuntimeException(String.format("invalid ams url %s", url));
        }
        return null;
    }

    private static AmsServerInfo findAmsServerInfo(String serviceName, String zkServerAddress, String cluster) throws Exception {
        switch (serviceName) {
            case "TableMetastore": {
                return JacksonUtil.parseObject(ZookeeperService.getInstance(zkServerAddress).getData(AmsHAProperties.getTableServiceMasterPath(cluster)), AmsServerInfo.class);
            }
            case "OptimizeManager": {
                return JacksonUtil.parseObject(ZookeeperService.getInstance(zkServerAddress).getData(AmsHAProperties.getOptimizingServiceMasterPath(cluster)), AmsServerInfo.class);
            }
        }
        throw new RuntimeException(String.format("invalid service name %s", serviceName));
    }

    public String schema() {
        return this.schema;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String catalogName() {
        return this.catalogName;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public String url() {
        return this.url;
    }

    public String serverUrl() {
        return String.format(THRIFT_URL_FORMAT, this.host, this.port, "", "");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.schema).add("host", (Object)this.host).add("port", this.port).add("catalogName", (Object)this.catalogName).add(PARAM_SOCKET_TIMEOUT, this.socketTimeout).add("url", (Object)this.url).toString();
    }
}

