/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;

class OrcToIcebergVisitor
extends OrcSchemaVisitor<Optional<Types.NestedField>> {
    OrcToIcebergVisitor() {
    }

    @Override
    public Optional<Types.NestedField> record(TypeDescription record, List<String> names, List<Optional<Types.NestedField>> fields) {
        boolean isOptional = ORCSchemaUtil.isOptional(record);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(record);
        if (!icebergIdOpt.isPresent() || fields.stream().noneMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        Types.StructType structType = Types.StructType.of(fields.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return Optional.of(Types.NestedField.of((int)icebergIdOpt.get(), (boolean)isOptional, (String)this.currentFieldName(), (Type)structType));
    }

    @Override
    public Optional<Types.NestedField> list(TypeDescription array, Optional<Types.NestedField> element) {
        boolean isOptional = ORCSchemaUtil.isOptional(array);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(array);
        if (!icebergIdOpt.isPresent() || !element.isPresent()) {
            return Optional.empty();
        }
        Types.NestedField foundElement = element.get();
        Types.ListType listTypeWithElem = ORCSchemaUtil.isOptional((TypeDescription)array.getChildren().get(0)) ? Types.ListType.ofOptional((int)foundElement.fieldId(), (Type)foundElement.type()) : Types.ListType.ofRequired((int)foundElement.fieldId(), (Type)foundElement.type());
        return Optional.of(Types.NestedField.of((int)icebergIdOpt.get(), (boolean)isOptional, (String)this.currentFieldName(), (Type)listTypeWithElem));
    }

    @Override
    public Optional<Types.NestedField> map(TypeDescription map, Optional<Types.NestedField> key, Optional<Types.NestedField> value) {
        boolean isOptional = ORCSchemaUtil.isOptional(map);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(map);
        if (!(icebergIdOpt.isPresent() && key.isPresent() && value.isPresent())) {
            return Optional.empty();
        }
        Types.NestedField foundKey = key.get();
        Types.NestedField foundValue = value.get();
        Types.MapType mapTypeWithKV = ORCSchemaUtil.isOptional((TypeDescription)map.getChildren().get(1)) ? Types.MapType.ofOptional((int)foundKey.fieldId(), (int)foundValue.fieldId(), (Type)foundKey.type(), (Type)foundValue.type()) : Types.MapType.ofRequired((int)foundKey.fieldId(), (int)foundValue.fieldId(), (Type)foundKey.type(), (Type)foundValue.type());
        return Optional.of(Types.NestedField.of((int)icebergIdOpt.get(), (boolean)isOptional, (String)this.currentFieldName(), (Type)mapTypeWithKV));
    }

    @Override
    public Optional<Types.NestedField> primitive(TypeDescription primitive) {
        Types.NestedField foundField;
        boolean isOptional = ORCSchemaUtil.isOptional(primitive);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(primitive);
        if (!icebergIdOpt.isPresent()) {
            return Optional.empty();
        }
        int icebergID = icebergIdOpt.get();
        String name = this.currentFieldName();
        block0 : switch (primitive.getCategory()) {
            case BOOLEAN: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.BooleanType.get());
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.IntegerType.get());
                break;
            }
            case LONG: {
                String longAttributeValue = primitive.getAttributeValue("iceberg.long-type");
                ORCSchemaUtil.LongType longType = longAttributeValue == null ? ORCSchemaUtil.LongType.LONG : ORCSchemaUtil.LongType.valueOf(longAttributeValue);
                switch (longType) {
                    case TIME: {
                        foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.TimeType.get());
                        break block0;
                    }
                    case LONG: {
                        foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.LongType.get());
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Long type found in ORC type attribute");
            }
            case FLOAT: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.FloatType.get());
                break;
            }
            case DOUBLE: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.DoubleType.get());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.StringType.get());
                break;
            }
            case BINARY: {
                String binaryAttributeValue = primitive.getAttributeValue("iceberg.binary-type");
                ORCSchemaUtil.BinaryType binaryType = binaryAttributeValue == null ? ORCSchemaUtil.BinaryType.BINARY : ORCSchemaUtil.BinaryType.valueOf(binaryAttributeValue);
                switch (binaryType) {
                    case UUID: {
                        foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.UUIDType.get());
                        break block0;
                    }
                    case FIXED: {
                        int fixedLength = Integer.parseInt(primitive.getAttributeValue("iceberg.length"));
                        foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.FixedType.ofLength((int)fixedLength));
                        break block0;
                    }
                    case BINARY: {
                        foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.BinaryType.get());
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Binary type found in ORC type attribute");
            }
            case DATE: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.DateType.get());
                break;
            }
            case TIMESTAMP: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.TimestampType.withoutZone());
                break;
            }
            case TIMESTAMP_INSTANT: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.TimestampType.withZone());
                break;
            }
            case DECIMAL: {
                foundField = Types.NestedField.of((int)icebergID, (boolean)isOptional, (String)name, (Type)Types.DecimalType.of((int)primitive.getPrecision(), (int)primitive.getScale()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't handle " + primitive);
            }
        }
        return Optional.of(foundField);
    }
}

