/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnStatistics;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class OrcFooterReader {
    public static OrcColumnStatistics readStatistics(Reader orcReader) {
        TypeDescription orcSchema = orcReader.getSchema();
        ColumnStatistics[] orcStatistics = orcReader.getStatistics();
        StructType sparkSchema = OrcUtils.toCatalystSchema(orcSchema);
        return OrcFooterReader.convertStatistics((DataType)sparkSchema, new LinkedList<ColumnStatistics>(Arrays.asList(orcStatistics)));
    }

    private static OrcColumnStatistics convertStatistics(DataType sparkSchema, Queue<ColumnStatistics> orcStatistics) {
        OrcColumnStatistics statistics = new OrcColumnStatistics(orcStatistics.remove());
        if (sparkSchema instanceof StructType) {
            for (StructField field : ((StructType)sparkSchema).fields()) {
                statistics.add(OrcFooterReader.convertStatistics(field.dataType(), orcStatistics));
            }
        } else if (sparkSchema instanceof MapType) {
            statistics.add(OrcFooterReader.convertStatistics(((MapType)sparkSchema).keyType(), orcStatistics));
            statistics.add(OrcFooterReader.convertStatistics(((MapType)sparkSchema).valueType(), orcStatistics));
        } else if (sparkSchema instanceof ArrayType) {
            statistics.add(OrcFooterReader.convertStatistics(((ArrayType)sparkSchema).elementType(), orcStatistics));
        }
        return statistics;
    }
}

