/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.SDKStreamDrainer;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class S3ARemoteObject {
    private static final Logger LOG = LoggerFactory.getLogger(S3ARemoteObject.class);
    private final S3AReadOpContext context;
    private final S3ObjectAttributes s3Attributes;
    private final S3AInputStream.InputStreamCallbacks client;
    private final S3AInputStreamStatistics streamStatistics;
    private final ChangeTracker changeTracker;
    private final String uri;
    private static final int DRAIN_BUFFER_SIZE = 16384;

    public S3ARemoteObject(S3AReadOpContext context, S3ObjectAttributes s3Attributes, S3AInputStream.InputStreamCallbacks client, S3AInputStreamStatistics streamStatistics, ChangeTracker changeTracker) {
        Validate.checkNotNull((Object)context, (String)"context");
        Validate.checkNotNull((Object)s3Attributes, (String)"s3Attributes");
        Validate.checkNotNull((Object)client, (String)"client");
        Validate.checkNotNull((Object)streamStatistics, (String)"streamStatistics");
        Validate.checkNotNull((Object)changeTracker, (String)"changeTracker");
        this.context = context;
        this.s3Attributes = s3Attributes;
        this.client = client;
        this.streamStatistics = streamStatistics;
        this.changeTracker = changeTracker;
        this.uri = this.getPath();
    }

    public Invoker getReadInvoker() {
        return this.context.getReadInvoker();
    }

    public S3AInputStreamStatistics getStatistics() {
        return this.streamStatistics;
    }

    public String getPath() {
        return S3ARemoteObject.getPath(this.s3Attributes);
    }

    public static String getPath(S3ObjectAttributes s3Attributes) {
        return String.format("s3a://%s/%s", s3Attributes.getBucket(), s3Attributes.getKey());
    }

    public long size() {
        return this.s3Attributes.getLen();
    }

    public ResponseInputStream<GetObjectResponse> openForRead(long offset, int size) throws IOException {
        Validate.checkNotNegative((long)offset, (String)"offset");
        Validate.checkLessOrEqual((long)offset, (String)"offset", (long)this.size(), (String)"size()");
        Validate.checkLessOrEqual((long)size, (String)"size", (long)(this.size() - offset), (String)"size() - offset");
        this.streamStatistics.streamOpened();
        GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)this.client.newGetRequestBuilder(this.s3Attributes.getKey()).range(S3AUtils.formatRange(offset, offset + (long)size - 1L)).applyMutation(this.changeTracker::maybeApplyConstraint)).build();
        String operation = String.format("%s %s at %d", "open", this.uri, offset);
        ResponseInputStream object = null;
        try (DurationTracker tracker = this.streamStatistics.initiateGetRequest();){
            object = (ResponseInputStream)Invoker.once(operation, this.uri, () -> this.client.getObject(request));
        }
        this.changeTracker.processResponse((GetObjectResponse)object.response(), operation, offset);
        return object;
    }

    void close(ResponseInputStream<GetObjectResponse> inputStream, int numRemainingBytes) {
        SDKStreamDrainer<ResponseInputStream<GetObjectResponse>> drainer = new SDKStreamDrainer<ResponseInputStream<GetObjectResponse>>(this.uri, inputStream, false, numRemainingBytes, this.streamStatistics, "close() operation");
        if ((long)numRemainingBytes <= this.context.getAsyncDrainThreshold()) {
            drainer.apply();
        } else {
            LOG.debug("initiating asynchronous drain of {} bytes", (Object)numRemainingBytes);
            this.client.submit(drainer);
        }
    }
}

