/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.CommandId;
import org.apache.ignite.internal.metastorage.CompactionRevisionUpdateListener;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.RevisionUpdateListener;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.StatementResult;
import org.apache.ignite.internal.metastorage.server.ChecksumAndRevisions;
import org.apache.ignite.internal.metastorage.server.Condition;
import org.apache.ignite.internal.metastorage.server.If;
import org.apache.ignite.internal.metastorage.server.KeyValueUpdateContext;
import org.apache.ignite.internal.metastorage.server.NotificationEnqueuedListener;
import org.apache.ignite.internal.metastorage.server.RecoveryRevisionsListener;
import org.apache.ignite.internal.metastorage.server.WatchEventHandlingCallback;
import org.apache.ignite.internal.raft.IndexWithTerm;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public interface KeyValueStorage
extends ManuallyCloseable {
    public static final byte[] INVOKE_RESULT_TRUE_BYTES = new byte[]{ByteUtils.booleanToByte((boolean)true)};
    public static final byte[] INVOKE_RESULT_FALSE_BYTES = new byte[]{ByteUtils.booleanToByte((boolean)false)};

    public void start();

    public long revision();

    public Entry get(byte[] var1);

    public Entry get(byte[] var1, long var2);

    public List<Entry> getAll(List<byte[]> var1);

    public List<Entry> getAll(List<byte[]> var1, long var2);

    public void setIndexAndTerm(long var1, long var3);

    @Nullable
    public IndexWithTerm getIndexWithTerm();

    public void saveConfiguration(byte[] var1, long var2, long var4);

    public byte @Nullable [] getConfiguration();

    public void put(byte[] var1, byte[] var2, KeyValueUpdateContext var3);

    public void putAll(List<byte[]> var1, List<byte[]> var2, KeyValueUpdateContext var3);

    public void remove(byte[] var1, KeyValueUpdateContext var2);

    public void removeAll(List<byte[]> var1, KeyValueUpdateContext var2);

    public void removeByPrefix(byte[] var1, KeyValueUpdateContext var2);

    public boolean invoke(Condition var1, List<Operation> var2, List<Operation> var3, KeyValueUpdateContext var4, CommandId var5);

    public StatementResult invoke(If var1, KeyValueUpdateContext var2, CommandId var3);

    public Cursor<Entry> range(byte[] var1, byte @Nullable [] var2);

    public Cursor<Entry> range(byte[] var1, byte @Nullable [] var2, long var3);

    public void watchRange(byte[] var1, byte @Nullable [] var2, long var3, WatchListener var5);

    public void watchExact(byte[] var1, long var2, WatchListener var4);

    public void watchExact(Collection<byte[]> var1, long var2, WatchListener var4);

    public void startWatches(long var1, WatchEventHandlingCallback var3);

    public void removeWatch(WatchListener var1);

    public void compact(long var1);

    public void stopCompaction();

    public CompletableFuture<Void> snapshot(Path var1);

    public void restoreSnapshot(Path var1);

    public byte @Nullable [] nextKey(byte[] var1);

    public HybridTimestamp timestampByRevision(long var1);

    public long revisionByTimestamp(HybridTimestamp var1);

    public void setRecoveryRevisionsListener(@Nullable RecoveryRevisionsListener var1);

    public void registerRevisionUpdateListener(RevisionUpdateListener var1);

    public void unregisterRevisionUpdateListener(RevisionUpdateListener var1);

    public void registerCompactionRevisionUpdateListener(CompactionRevisionUpdateListener var1);

    public void unregisterCompactionRevisionUpdateListener(CompactionRevisionUpdateListener var1);

    public void registerNotificationEnqueuedListener(NotificationEnqueuedListener var1);

    public CompletableFuture<Void> notifyRevisionUpdateListenerOnStart(long var1);

    public void advanceSafeTime(KeyValueUpdateContext var1);

    public void saveCompactionRevision(long var1, KeyValueUpdateContext var3);

    public void setCompactionRevision(long var1);

    public long getCompactionRevision();

    public void updateCompactionRevision(long var1, KeyValueUpdateContext var3);

    public long checksum(long var1);

    public ChecksumAndRevisions checksumAndRevisions(long var1);

    public void clear();

    public Revisions revisions();

    public CompletableFuture<Void> flush();
}

