/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.util.ColocationUtils;
import org.apache.ignite.internal.util.HashCalculator;
import org.jetbrains.annotations.Nullable;

public class RowImpl
extends BinaryTupleReader
implements Row {
    private final SchemaDescriptor schema;
    private final BinaryRow row;
    private final BinaryTupleSchema binaryTupleSchema;
    private final boolean keyOnly;
    private int colocationHash;

    RowImpl(boolean keyOnly, SchemaDescriptor schema, BinaryTupleSchema binaryTupleSchema, BinaryRow row) {
        super(binaryTupleSchema.elementCount(), row.tupleSlice());
        this.keyOnly = keyOnly;
        this.row = row;
        this.schema = schema;
        this.binaryTupleSchema = binaryTupleSchema;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean keyOnly() {
        return this.keyOnly;
    }

    @Override
    public Object value(int col) {
        return this.binaryTupleSchema.value(this, col);
    }

    @Override
    @Nullable
    public BigDecimal decimalValue(int col) {
        return this.binaryTupleSchema.decimalValue(this, col);
    }

    @Override
    public int schemaVersion() {
        return this.row.schemaVersion();
    }

    @Override
    public ByteBuffer tupleSlice() {
        return this.row.tupleSlice();
    }

    @Override
    public int tupleSliceLength() {
        return this.row.tupleSliceLength();
    }

    @Override
    public int colocationHash() {
        int h0 = this.colocationHash;
        if (h0 == 0) {
            HashCalculator hashCalc = new HashCalculator();
            for (Column c : this.schema.colocationColumns()) {
                int idx;
                int n = idx = this.keyOnly ? c.positionInKey() : c.positionInRow();
                assert (idx >= 0) : c;
                ColocationUtils.append(hashCalc, this.value(idx), c.type());
            }
            this.colocationHash = h0 = hashCalc.hash();
        }
        return h0;
    }

    public BinaryTupleReader binaryTuple() {
        return new BinaryTuple(this.binaryTupleSchema.elementCount(), this.row.tupleSlice());
    }

    @Override
    public void copyValue(BinaryTupleBuilder builder, int columnIndex) {
        this.copyRawValue(builder, columnIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowImpl row1 = (RowImpl)o;
        return this.row.equals(row1.row);
    }

    public int hashCode() {
        return this.row.hashCode();
    }
}

