/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.StartBuildingIndexEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite.internal.table.distributed.replicator.IndexBuilderTxRwOperationTracker;
import org.apache.ignite.internal.table.distributed.replicator.ReplicatorUtils;
import org.apache.ignite.internal.table.distributed.replicator.StaleTransactionOperationException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;

public class PartitionReplicaBuildIndexProcessor {
    private final IgniteSpinBusyLock busyLock;
    private final int tableId;
    private final IndexMetaStorage indexMetaStorage;
    private final IndexBuilderTxRwOperationTracker txRwOperationTracker;
    private final CatalogService catalogService;
    private final EventListener<CatalogEventParameters> listener = this::onIndexBuilding;

    PartitionReplicaBuildIndexProcessor(IgniteSpinBusyLock busyLock, int tableId, IndexMetaStorage indexMetaStorage, CatalogService catalogService) {
        this.busyLock = busyLock;
        this.tableId = tableId;
        this.indexMetaStorage = indexMetaStorage;
        this.txRwOperationTracker = new IndexBuilderTxRwOperationTracker();
        this.catalogService = catalogService;
        this.prepareIndexBuilderTxRwOperationTracker();
    }

    IndexBuilderTxRwOperationTracker tracker() {
        return this.txRwOperationTracker;
    }

    void onShutdown() {
        assert (this.busyLock.blockedByCurrentThread()) : "Busy lock must be locked by the current thread.";
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_BUILDING, this.listener);
        this.txRwOperationTracker.close();
    }

    void incrementRwOperationCountIfNeeded(ReplicaRequest request) {
        int rwTxActiveCatalogVersion;
        if (request instanceof ReadWriteReplicaRequest && !this.txRwOperationTracker.incrementOperationCount(rwTxActiveCatalogVersion = ReplicatorUtils.rwTxActiveCatalogVersion(this.catalogService, (ReadWriteReplicaRequest)request))) {
            throw new StaleTransactionOperationException(((ReadWriteReplicaRequest)request).transactionId());
        }
    }

    void decrementRwOperationCountIfNeeded(ReplicaRequest request) {
        if (request instanceof ReadWriteReplicaRequest) {
            this.txRwOperationTracker.decrementOperationCount(ReplicatorUtils.rwTxActiveCatalogVersion(this.catalogService, (ReadWriteReplicaRequest)request));
        }
    }

    private void prepareIndexBuilderTxRwOperationTracker() {
        IndexMeta indexMeta = ReplicatorUtils.latestIndexMetaInBuildingStatus(this.catalogService, this.indexMetaStorage, this.tableId);
        if (indexMeta != null) {
            this.txRwOperationTracker.updateMinAllowedCatalogVersionForStartOperation(indexMeta.statusChange(MetaIndexStatus.REGISTERED).catalogVersion());
        }
        this.catalogService.listen((Event)CatalogEvent.INDEX_BUILDING, this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> onIndexBuilding(CatalogEventParameters parameters) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.trueCompletedFuture();
        }
        try {
            int indexId = ((StartBuildingIndexEventParameters)parameters).indexId();
            IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexId);
            assert (indexMeta != null) : "indexId=" + indexId + ", catalogVersion=" + parameters.catalogVersion();
            MetaIndexStatusChange registeredStatusChange = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
            if (indexMeta.tableId() == this.tableId) {
                this.txRwOperationTracker.updateMinAllowedCatalogVersionForStartOperation(registeredStatusChange.catalogVersion());
            }
            CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

