/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.lang.AsyncCursor;

public class AntiHijackAsyncCursor<T>
implements AsyncCursor<T> {
    private final AsyncCursor<T> cursor;
    private final Executor asyncContinuationExecutor;

    public AntiHijackAsyncCursor(AsyncCursor<T> cursor, Executor asyncContinuationExecutor) {
        this.cursor = cursor;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public Iterable<T> currentPage() {
        return this.cursor.currentPage();
    }

    public int currentPageSize() {
        return this.cursor.currentPageSize();
    }

    public CompletableFuture<? extends AsyncCursor<T>> fetchNextPage() {
        return PublicApiThreading.preventThreadHijack((CompletableFuture)this.cursor.fetchNextPage(), (Executor)this.asyncContinuationExecutor).thenApply(nextCursor -> new AntiHijackAsyncCursor<T>(nextCursor, this.asyncContinuationExecutor));
    }

    public boolean hasMorePages() {
        return this.cursor.hasMorePages();
    }

    public CompletableFuture<Void> closeAsync() {
        return PublicApiThreading.preventThreadHijack((CompletableFuture)this.cursor.closeAsync(), (Executor)this.asyncContinuationExecutor);
    }
}

