/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.configuration.ConfigurationManager;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.presentation.HoconPresentation;
import org.apache.ignite.internal.rest.RestFactory;

@Factory
public class PresentationsFactory
implements RestFactory {
    private ConfigurationPresentation<String> nodeCfgPresentation;
    private ConfigurationPresentation<String> clusterCfgPresentation;

    public PresentationsFactory(ConfigurationManager nodeCfgMgr, ConfigurationManager clusterCfgMgr) {
        this.nodeCfgPresentation = new HoconPresentation(nodeCfgMgr.configurationRegistry());
        this.clusterCfgPresentation = new HoconPresentation(clusterCfgMgr.configurationRegistry());
    }

    @Bean
    @Singleton
    @Named(value="clusterCfgPresentation")
    public ConfigurationPresentation<String> clusterCfgPresentation() {
        return this.clusterCfgPresentation;
    }

    @Bean
    @Singleton
    @Named(value="nodeCfgPresentation")
    public ConfigurationPresentation<String> nodeCfgPresentation() {
        return this.nodeCfgPresentation;
    }

    public void cleanResources() {
        this.nodeCfgPresentation = null;
        this.clusterCfgPresentation = null;
    }
}

