/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.util.CryptoUtils;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.entity.dto.sms.TencentSmsProperties;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsClientImpl.class);
    private static final String RESPONSE_OK = "Ok";
    private static final String REGION = "ap-guangzhou";
    private static final String API_VERSION = "2021-01-11";
    private static final String ACTION = "SendSms";
    private static final String HOST = "sms.tencentcloudapi.com";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private String appId;
    private String signName;
    private String templateId;
    private String secretId;
    private String secretKey;

    public TencentSmsClientImpl(TencentSmsProperties config) {
        if (config != null) {
            this.appId = config.getAppId();
            this.signName = config.getSignName();
            this.templateId = config.getTemplateId();
            this.secretId = config.getSecretId();
            this.secretKey = config.getSecretKey();
        }
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        String instance = null;
        String priority = null;
        String content = null;
        if (alert.getCommonLabels() != null) {
            instance = (String)alert.getCommonLabels().get("instance");
            priority = (String)alert.getCommonLabels().get("priority");
            content = (String)alert.getCommonAnnotations().get("summary");
            String string = content = content == null ? (String)alert.getCommonAnnotations().get("description") : content;
            if (content == null) {
                content = alert.getCommonAnnotations().values().stream().findFirst().orElse(null);
            }
        }
        String[] templateValues = new String[]{instance == null ? alert.getGroupKey() : instance, priority == null ? "unknown" : priority, content};
        String[] phones = new String[]{receiver.getPhone()};
        this.sendSms(this.appId, this.signName, this.templateId, templateValues, phones);
    }

    public void sendSms(String appId, String signName, String templateId, String[] templateValues, String[] phones) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("SmsSdkAppId", appId);
            params.put("SignName", signName);
            params.put("TemplateId", templateId);
            params.put("TemplateParamSet", templateValues);
            params.put("PhoneNumberSet", phones);
            String payload = JsonUtil.toJson(params);
            String authorization = TencentSmsClientImpl.calculateAuthorization(this.secretId, this.secretKey, "sms", HOST, REGION, ACTION, API_VERSION, payload);
            HttpPost httpPost = new HttpPost("https://sms.tencentcloudapi.com");
            httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
            httpPost.setHeader("Host", HOST);
            httpPost.setHeader("X-TC-Action", ACTION);
            httpPost.setHeader("X-TC-Timestamp", timestamp);
            httpPost.setHeader("X-TC-Version", API_VERSION);
            httpPost.setHeader("X-TC-Region", REGION);
            httpPost.setHeader("Authorization", authorization);
            httpPost.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
            log.debug("Sending SMS request to {}, payload: {}", (Object)httpPost.getURI(), (Object)payload);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("SMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
                if (statusCode != 200) {
                    throw new SendMessageException("HTTP request failed with status code: " + statusCode);
                }
                JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
                JsonNode responseNode = jsonResponse.get("Response");
                JsonNode error = responseNode.get("Error");
                if (error != null) {
                    String code = error.get("Code").asText();
                    String message = error.get("Message").asText();
                    throw new SendMessageException(code + ":" + message);
                }
                JsonNode sendStatusSet = responseNode.get("SendStatusSet");
                if (sendStatusSet != null && sendStatusSet.isArray() && sendStatusSet.size() > 0) {
                    JsonNode firstStatus = sendStatusSet.get(0);
                    String code = firstStatus.get("Code").asText();
                    String message = firstStatus.get("Message").asText();
                    if (!RESPONSE_OK.equals(code)) {
                        throw new SendMessageException(code + ":" + message);
                    }
                }
                log.info("Successfully sent SMS to phones: {}", (Object)String.join((CharSequence)",", phones));
            }
        }
        catch (Exception e) {
            log.warn("Failed to send SMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    @Override
    public String getType() {
        return "tencent";
    }

    @Override
    public boolean checkConfig() {
        return !this.appId.isBlank() && !this.templateId.isBlank() && !this.secretId.isBlank() && !this.secretKey.isBlank();
    }

    public static String calculateAuthorization(String secretId, String secretKey, String service, String host, String region, String action, String version, String payload) throws Exception {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date(Long.valueOf(timestamp + "000")));
        String httpRequestMethod = "POST";
        String canonicalUri = "/";
        String canonicalQueryString = "";
        String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + host + "\n";
        String signedHeaders = "content-type;host";
        String hashedRequestPayload = CryptoUtils.sha256Hex(payload);
        String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String algorithm = "TC3-HMAC-SHA256";
        String credentialScope = date + "/" + service + "/tc3_request";
        String hashedCanonicalRequest = CryptoUtils.sha256Hex(canonicalRequest);
        String stringToSign = algorithm + "\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        byte[] secretDate = CryptoUtils.hmac256(("TC3" + secretKey).getBytes(UTF8), date);
        byte[] secretService = CryptoUtils.hmac256(secretDate, service);
        byte[] secretSigning = CryptoUtils.hmac256(secretService, "tc3_request");
        String signature = DatatypeConverter.printHexBinary((byte[])CryptoUtils.hmac256(secretSigning, stringToSign)).toLowerCase();
        return algorithm + " Credential=" + secretId + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
    }
}

