/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hertzbeat.manager.pojo.dto.Hierarchy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UtilityClass {
    private static final Logger log = LoggerFactory.getLogger(UtilityClass.class);

    public static String validateExpressionSyntax(String fieldConditions) {
        try {
            log.debug("Validating expression syntax: {}", (Object)fieldConditions);
            if (fieldConditions == null || fieldConditions.trim().isEmpty()) {
                return "Error: Field conditions cannot be empty";
            }
            if (!UtilityClass.hasBalancedParentheses(fieldConditions)) {
                return "Error: Unbalanced parentheses in field conditions. Please check your expression syntax.";
            }
            String operatorValidation = UtilityClass.validateOperators(fieldConditions);
            if (!operatorValidation.equals("VALID")) {
                return operatorValidation;
            }
            String logicalValidation = UtilityClass.validateLogicalConnectors(fieldConditions);
            if (!logicalValidation.equals("VALID")) {
                return logicalValidation;
            }
            String functionValidation = UtilityClass.validateFunctions(fieldConditions);
            if (!functionValidation.equals("VALID")) {
                return functionValidation;
            }
            log.debug("Expression syntax validation passed for: {}", (Object)fieldConditions);
            return "VALID";
        }
        catch (Exception e) {
            log.error("Error during expression syntax validation: {}", (Object)e.getMessage(), (Object)e);
            return String.format("Error: Unable to validate expression syntax: %s", e.getMessage());
        }
    }

    public static boolean hasBalancedParentheses(String expression) {
        int count = 0;
        for (char c : expression.toCharArray()) {
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != ')' || --count >= 0) continue;
            return false;
        }
        return count == 0;
    }

    public static String validateOperators(String fieldConditions) {
        String[] invalidOperators;
        String[] numericOperators = new String[]{">", "<", ">=", "<=", "==", "!=", "exists()", "!exists()"};
        String[] stringOperators = new String[]{"equals(", "contains(", "matches(", "exists()", "!equals(", "!contains(", "!matches(", "!exists()"};
        String[] logicalOperators = new String[]{" and ", " or "};
        String tempExpression = fieldConditions.replaceAll("\"[^\"]*\"", "VALUE").replaceAll("'[^']*'", "VALUE").replaceAll("\\w+\\([^)]*\\)", "FUNCTION");
        for (String invalidOp : invalidOperators = new String[]{"&&", "||", "AND", "OR", "=", "!="}) {
            if (!tempExpression.contains(invalidOp)) continue;
            if (invalidOp.equals("&&") || invalidOp.equals("||")) {
                return String.format("Error: Use 'and'/'or' instead of '%s' for logical operations", invalidOp);
            }
            if (invalidOp.equals("AND") || invalidOp.equals("OR")) {
                return String.format("Error: Use lowercase '%s' for logical operations", invalidOp.toLowerCase());
            }
            if (!invalidOp.equals("=")) continue;
            return "Error: Use '==' for equality comparison, not '='";
        }
        if (tempExpression.matches(".*[#$%^&*+\\[\\]{}|\\\\;:'\"`~].*")) {
            return "Error: Expression contains unsupported special characters. Use only supported operators and functions.";
        }
        return "VALID";
    }

    public static String validateLogicalConnectors(String fieldConditions) {
        if (fieldConditions.matches(".*(\\S(and|or)\\S).*")) {
            return "Error: Logical operators 'and'/'or' must be surrounded by spaces";
        }
        if (fieldConditions.matches(".*(and\\s+and|or\\s+or|and\\s+or\\s+and|or\\s+and\\s+or).*")) {
            return "Error: Consecutive logical operators found. Use parentheses to group conditions properly.";
        }
        String trimmed = fieldConditions.trim();
        if (trimmed.startsWith("and ") || trimmed.startsWith("or ") || trimmed.endsWith(" and") || trimmed.endsWith(" or")) {
            return "Error: Expression cannot start or end with logical operators 'and'/'or'";
        }
        return "VALID";
    }

    /*
     * WARNING - void declaration
     */
    public static String validateFunctions(String fieldConditions) {
        CharSequence[] supportedFunctions = new String[]{"equals", "contains", "matches", "exists", "!equals", "!contains", "!matches", "!exists"};
        Pattern functionPattern = Pattern.compile("(!?\\w+)\\s*\\(([^)]*)\\)");
        Matcher matcher = functionPattern.matcher(fieldConditions);
        while (matcher.find()) {
            void var10_13;
            String[] args;
            String functionName = matcher.group(1);
            String functionArgs = matcher.group(2);
            boolean isSupported = false;
            for (String string : supportedFunctions) {
                if (!functionName.equals(string)) continue;
                isSupported = true;
                break;
            }
            if (!isSupported) {
                return String.format("Error: Unsupported function '%s'. Supported functions: %s", functionName, String.join((CharSequence)", ", supportedFunctions));
            }
            if (functionName.equals("exists") || functionName.equals("!exists")) {
                args = functionArgs.trim().isEmpty() ? new String[]{} : functionArgs.split(",");
                if (args.length <= 1) continue;
                return String.format("Error: Function '%s' should have at most one parameter", functionName);
            }
            args = functionArgs.split(",");
            if (args.length != 2) {
                return String.format("Error: Function '%s' requires exactly 2 parameters (field, value)", functionName);
            }
            String[] stringArray = args;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_13 < n) {
                String arg = stringArray[var10_13];
                if (arg.trim().isEmpty()) {
                    return String.format("Error: Function '%s' has empty parameter", functionName);
                }
                ++var10_13;
            }
        }
        return "VALID";
    }

    public static Map<String, String> parseKeyValuePairs(String input) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        if (input == null || input.trim().isEmpty()) {
            return result;
        }
        for (String pair : pairs = input.split(",")) {
            String[] keyValue = pair.split(":");
            if (keyValue.length != 2) continue;
            result.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return result;
    }

    public static Hierarchy findMetricInHierarchy(List<Hierarchy> hierarchies, String metricName) {
        for (Hierarchy hierarchy : hierarchies) {
            Hierarchy found;
            boolean hasLeafChildren;
            if (metricName.equals(hierarchy.getValue()) && hierarchy.getChildren() != null && !hierarchy.getChildren().isEmpty() && (hasLeafChildren = hierarchy.getChildren().stream().anyMatch(child -> child.getIsLeaf() != null && child.getIsLeaf() != false))) {
                return hierarchy;
            }
            if (hierarchy.getChildren() == null || (found = UtilityClass.findMetricInHierarchy(hierarchy.getChildren(), metricName)) == null) continue;
            return found;
        }
        return null;
    }

    public static boolean isFieldValidForMetric(Hierarchy metricHierarchy, String fieldName) {
        if (metricHierarchy.getChildren() == null) {
            return false;
        }
        for (Hierarchy child : metricHierarchy.getChildren()) {
            if (child.getIsLeaf() != null && child.getIsLeaf().booleanValue() && fieldName.equals(child.getValue())) {
                return true;
            }
            if (child.getChildren() == null || !UtilityClass.isFieldValidForMetric(child, fieldName)) continue;
            return true;
        }
        return false;
    }

    public static List<String> extractFieldNamesFromConditions(String fieldConditions) {
        String[] parts;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String part : parts = fieldConditions.split("\\s+(and|or|&&|\\|\\|)\\s+|[()]+")) {
            String fieldName;
            if ((part = part.trim()).isEmpty()) continue;
            if (part.contains("equals(")) {
                fieldName = UtilityClass.extractFieldFromEquals(part);
                if (fieldName == null || fieldNames.contains(fieldName)) continue;
                fieldNames.add(fieldName);
                continue;
            }
            fieldName = UtilityClass.extractFieldFromComparison(part);
            if (fieldName == null || fieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    public static String extractFieldFromEquals(String condition) {
        int startParen = condition.indexOf(40);
        int comma = condition.indexOf(44);
        if (startParen != -1 && comma != -1 && comma > startParen) {
            String fieldName = condition.substring(startParen + 1, comma).trim();
            if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            return fieldName;
        }
        return null;
    }

    public static String extractFieldFromComparison(String condition) {
        String[] operators;
        for (String operator : operators = new String[]{" >= ", " <= ", " > ", " < ", " == ", " != "}) {
            String fieldName;
            if (!condition.contains(operator) || !(fieldName = condition.split(operator)[0].trim()).matches("[a-zA-Z_][a-zA-Z0-9_]*")) continue;
            return fieldName;
        }
        return null;
    }

    public static ObjectNode formatHierarchyAsJson(ObjectMapper mapper, Hierarchy hierarchy) {
        ObjectNode node = mapper.createObjectNode();
        node.put("value", hierarchy.getValue());
        node.put("label", hierarchy.getLabel());
        if (hierarchy.getIsLeaf() != null && hierarchy.getIsLeaf().booleanValue()) {
            node.put("type", "field_parameter");
            if (hierarchy.getType() != null) {
                node.put("dataType", hierarchy.getType() == 0 ? "numeric" : "string");
            }
            if (hierarchy.getUnit() != null && !hierarchy.getUnit().trim().isEmpty()) {
                node.put("unit", hierarchy.getUnit());
            }
            node.put("description", "Available field parameter for alert conditions");
        } else {
            boolean hasLeafChildren = hierarchy.getChildren().stream().anyMatch(child -> child.getIsLeaf() != null && child.getIsLeaf() != false);
            if (hasLeafChildren) {
                node.put("type", "metric");
                node.put("description", "Metric with available field parameters");
            } else {
                node.put("type", "app");
                node.put("description", "Application with available metrics");
            }
            if (hierarchy.getChildren() != null && !hierarchy.getChildren().isEmpty()) {
                ArrayNode childrenArray = mapper.createArrayNode();
                for (Hierarchy child2 : hierarchy.getChildren()) {
                    childrenArray.add((JsonNode)UtilityClass.formatHierarchyAsJson(mapper, child2));
                }
                node.set("children", (JsonNode)childrenArray);
            }
        }
        return node;
    }

    public static String formatTimestamp(Long timestamp) {
        if (timestamp == null) {
            return "N/A";
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String getStatusText(Byte status) {
        if (status == null) {
            return "Unknown";
        }
        return switch (status) {
            case 0 -> "Paused";
            case 1 -> "Online";
            case 2 -> "Offline";
            case 3 -> "Unreachable";
            default -> "Unknown (" + status + ")";
        };
    }

    public static List<String> extractExistingMonitorIds(String expression) {
        ArrayList<String> monitorIds = new ArrayList<String>();
        String pattern = "equals\\(__instance__,\\s*\"([^\"]+)\"\\)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(expression);
        while (matcher.find()) {
            monitorIds.add(matcher.group(1));
        }
        return monitorIds;
    }

    public static String replaceInstanceConditions(String expression, String newMonitorCondition) {
        String groupedPattern = "\\(\\s*equals\\(__instance__,\\s*\"[^\"]+\"\\)(?:\\s+or\\s+equals\\(__instance__,\\s*\"[^\"]+\"\\))*\\s*\\)";
        if (expression.matches(".*" + groupedPattern + ".*")) {
            return expression.replaceFirst(groupedPattern, newMonitorCondition);
        }
        String singlePattern = "equals\\(__instance__,\\s*\"[^\"]+\"\\)";
        if (expression.matches(".*" + singlePattern + ".*")) {
            return expression.replaceFirst(singlePattern, newMonitorCondition);
        }
        return expression;
    }

    private UtilityClass() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

