/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.region;

import com.huaweicloud.sdk.core.region.EnvRegionProvider;
import com.huaweicloud.sdk.core.region.IRegionProvider;
import com.huaweicloud.sdk.core.region.ProfileRegionProvider;
import com.huaweicloud.sdk.core.region.Region;
import java.util.Objects;

public class RegionProviderChain
implements IRegionProvider {
    private final IRegionProvider[] providers;

    public RegionProviderChain(IRegionProvider[] providers) {
        this.providers = providers;
    }

    public static RegionProviderChain getDefaultRegionProviderChain(String serviceName) {
        IRegionProvider[] regionProviders = new IRegionProvider[]{new EnvRegionProvider(serviceName), new ProfileRegionProvider(serviceName)};
        return new RegionProviderChain(regionProviders);
    }

    @Override
    public Region getRegion(String regionId) {
        for (IRegionProvider provider : this.providers) {
            Region region = provider.getRegion(regionId);
            if (!Objects.nonNull(region)) continue;
            return region;
        }
        return null;
    }
}

