/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ErrorLoggingObservationHandler
implements ObservationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLoggingObservationHandler.class);
    private final Tracer tracer;
    private final List<Class<? extends Observation.Context>> supportedContextTypes;
    private final Consumer<Observation.Context> errorConsumer;

    public ErrorLoggingObservationHandler(Tracer tracer, List<Class<? extends Observation.Context>> supportedContextTypes) {
        this(tracer, supportedContextTypes, context -> logger.error("Traced Error: ", context.getError()));
    }

    public ErrorLoggingObservationHandler(Tracer tracer, List<Class<? extends Observation.Context>> supportedContextTypes, Consumer<Observation.Context> errorConsumer) {
        Assert.notNull((Object)tracer, (String)"Tracer must not be null");
        Assert.notNull(supportedContextTypes, (String)"SupportedContextTypes must not be null");
        Assert.notNull(errorConsumer, (String)"ErrorConsumer must not be null");
        this.tracer = tracer;
        this.supportedContextTypes = supportedContextTypes;
        this.errorConsumer = errorConsumer;
    }

    public boolean supportsContext(Observation.Context context) {
        return context == null ? false : this.supportedContextTypes.stream().anyMatch(clz -> clz.isInstance(context));
    }

    public void onError(Observation.Context context) {
        TracingObservationHandler.TracingContext tracingContext;
        if (context != null && (tracingContext = (TracingObservationHandler.TracingContext)context.get(TracingObservationHandler.TracingContext.class)) != null) {
            try (Tracer.SpanInScope val = this.tracer.withSpan(tracingContext.getSpan());){
                this.errorConsumer.accept(context);
            }
        }
    }
}

